% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialCPie.R
\name{runCPie}
\alias{runCPie}
\title{Run SpatialCPie}
\usage{
runCPie(counts, image = NULL, spotCoordinates = NULL,
  margin = "spot", resolutions = 2:4,
  assignmentFunction = function(k, x) kmeans(x, centers = k)$cluster,
  view = NULL)
}
\arguments{
\item{counts}{gene count matrix or a
\code{\link[SummarizedExperiment]{SummarizedExperiment-class}} object
containing count values.}

\item{image}{image to be used as background to the plot.}

\item{spotCoordinates}{\code{\link[base]{data.frame}} with pixel coordinates.
The rows should correspond to the columns (spatial areas) in the count file.}

\item{margin}{which margin to cluster.}

\item{resolutions}{\code{\link[base]{numeric}} vector specifying the
clustering resolutions.}

\item{assignmentFunction}{function to compute cluster assignments.}

\item{view}{\code{\link[shiny]{viewer}} object.}
}
\value{
a list with the following items:
\itemize{
\item \code{"clusters"}: Cluster assignments (may differ from \code{assignments})
\item \code{"clusterGraph"}: The cluster tree ggplot object
\item \code{"arrayPlot"}: The pie plot ggplot objects
}
}
\description{
Runs the SpatialCPie gadget.
}
\examples{
if (interactive()) {
    options(device.ask.default = FALSE)

    ## Set up coordinate system
    coordinates <- as.matrix(expand.grid(1:10, 1:10))

    ## Generate data set with three distinct genes generated by three
    ## distinct cell types
    profiles <- diag(rep(1, 3)) + runif(9)
    centers <- cbind(c(5, 2), c(2, 8), c(8, 2))
    mixes <- apply(coordinates, 1, function(x) {
        x <- exp(-colSums((centers - x) ^ 2) / 50)
        x / sum(x)
    })
    means <- 100 * profiles \%*\% mixes
    counts <- matrix(rpois(prod(dim(means)), means), nrow = nrow(profiles))
    colnames(counts) <- apply(
        coordinates,
        1,
        function(x) do.call(paste, c(as.list(x), list(sep = "x")))
    )
    rownames(counts) <- paste("gene", 1:nrow(counts))

    ## Run SpatialCPie
    runCPie(counts)
}
}
