% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialCPie.R
\name{.clusterGraph}
\alias{.clusterGraph}
\title{Cluster graph}
\usage{
.clusterGraph(assignments, clusterMeans, featureName,
  transitionProportions = "To", transitionLabels = FALSE,
  transitionThreshold = 0, numTopFeatures = 10)
}
\arguments{
\item{assignments}{\code{\link[base]{data.frame}} with columns \code{"name"},
\code{"resolution"}, and \code{"cluster"}.}

\item{clusterMeans}{\code{\link[base]{data.frame}} with columns \code{"name"},
\code{"resolution"}, \code{"cluster"}, \code{featureName}, and \code{"mean"}.}

\item{featureName}{\code{\link[base]{character}} with the name of the
clustered feature.}

\item{transitionProportions}{how to compute the transition proportions.
Possible values are:
\itemize{
\item \code{"From"}: based on the total number of assignments in the lower-resolution
cluster
\item \code{"To"}: based on the total number of assignments in the higher-resolution
cluster
}}

\item{transitionLabels}{\code{\link[base]{logical}} specifying whether to
show edge labels.}

\item{transitionThreshold}{hide edges with transition proportions below this
threshold.}

\item{numTopFeatures}{\code{\link[base]{integer}} specifying the number of
features to show in the hover tooltips.}
}
\value{
\code{\link[ggplot2]{ggplot}} object of the cluster graph.
}
\description{
Cluster graph
}
\keyword{internal}
