% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.import.R
\name{import.trinucleotides.counts}
\alias{import.trinucleotides.counts}
\title{import.trinucleotides.counts}
\usage{
import.trinucleotides.counts(data, reference = NULL)
}
\arguments{
\item{data}{a data.frame with variants having 6 columns: sample name, chromosome, start position, end position, ref, alt.}

\item{reference}{a BSgenome object with the reference genome to be used to retrieve flanking bases.}
}
\value{
A matrix with trinucleotides counts per patient.
}
\description{
Make trinucleotides counts matrix from input data for a given reference genome.
}
\examples{
data(ssm560_reduced)
library("BSgenome.Hsapiens.1000genomes.hs37d5")
trinucleotides_counts = import.trinucleotides.counts(data=ssm560_reduced, 
     reference=BSgenome.Hsapiens.1000genomes.hs37d5)


}
