% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addClusterCols.R
\name{markClusterCol}
\alias{markClusterCol}
\title{markClusterCol}
\usage{
markClusterCol(object, pattern)
}
\arguments{
\item{object}{Either a Seurat or SCE object containing clustering information}

\item{pattern}{pattern indicating which columns contain cluster information}
}
\value{
A Seurat or SCE object
}
\description{
A function to mark the columns containing cluster information in the metadata
or colData of a Seurat or SCE object. Columns are marked with "cluster_" 
prefix.
}
\examples{
sceObj <- readRDS(file.path(system.file(package = "Spaniel"),
                        "extdata/sceData.rds"))
sceObj <- markClusterCol(sceObj, "res")
}
