% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addCoordinates.R
\name{addCoordinates}
\alias{addCoordinates}
\title{Add coordinates to Object
Adds output of Spot Detector coordinates to 
Seurat object or SCE object created by createSeurat/createSCE. Details about 
how to use Spot Detector can be found:
https://github.com/SpatialTranscriptomicsResearch/st_spot_detector}
\usage{
addCoordinates(object, coordinatesFile, scaleFactor = NULL)
}
\arguments{
\item{object}{either a Seurat object or SCE}

\item{coordinatesFile}{path to coordinates file exported from Spot Detector}

\item{scaleFactor}{a scaling factor which can be used if the image file has 
been reduced in size after the coordinates were generated. For example if 
the image to be used is 10 percent the size of the original factor
scaleFactor = 10}
}
\value{
object
}
\description{
Add coordinates to Object
Adds output of Spot Detector coordinates to 
Seurat object or SCE object created by createSeurat/createSCE. Details about 
how to use Spot Detector can be found:
https://github.com/SpatialTranscriptomicsResearch/st_spot_detector
}
\examples{

### load a SingleCellExperiment Object 
sceObj <- readRDS(file.path(system.file(package = "Spaniel"),
                        "extdata/sceData.rds"))
### path to coordinates file exported from spot detector                        
coordinatesFile <-  file.path(system.file(package = "Spaniel"),
                        "spot_positions.tsv")                        
sceObj <- addCoordinates(sceObj, coordinatesFile)  

}
