% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{spatialPerCellQC}
\alias{spatialPerCellQC}
\title{spatialPerCellQC}
\usage{
spatialPerCellQC(
  spe,
  micronConvFact = 0.12,
  rmZeros = TRUE,
  negProbList = c("NegPrb", "Negative", "SystemControl", "Ms IgG1", "Rb IgG", "BLANK_",
    "NegControlProbe", "NegControlCodeword", "UnassignedCodeword", "Blank"),
  use_altexps = NULL
)
}
\arguments{
\item{spe}{A `SpatialExperiment` object containing spatial data.}

\item{micronConvFact}{Numeric factor to convert pixels to microns. Default
`0.12`.}

\item{rmZeros}{logical for removing zero counts cells (default is TRUE).}

\item{negProbList}{Character vector of patterns to identify negative probes.
Defaults include:
  Nanostring CosMx: `"NegPrb"`, `"Negative"`, `"SystemControl"`
  Xenium: `"NegControlProbe"`, `"NegControlCodeword"`, `"UnassignedCodeword"`
  MERFISH: `"Blank"`}

\item{use_altexps}{logical for `use_altexps` in `scuttle` package.
If TRUE uses the altexps for computing some metrics on it.
Useful for interoperability with `SpatialExperimentIO`.
(See \link[scuttle]{addPerCellQC} for additional details).}
}
\value{
A `SpatialExperiment` object with added QC metrics in `colData`.
}
\description{
Computes quality‐control metrics for each cell and adds them to `colData`.
}
\details{
Calculates sums and detected counts for control and target probes,
computes ratio and count‐area metrics, converts coords to microns for
CosMx, and drops zero‐count cells.
}
\examples{
example(readCosmxSPE)
spe <- spatialPerCellQC(spe)
}
