% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC.R
\name{getModelFormula}
\alias{getModelFormula}
\title{getModelFormula}
\usage{
getModelFormula(formulaVars, verbose = FALSE)
}
\arguments{
\item{formulaVars}{A named character vector mapping variable names
(e.g. `"log2SignalDensity"`, `"Area_um"`, etc.) to their corresponding
outlier label columns, typically from
`metadata(spe)$formula_variables`.}

\item{verbose}{Logical. If `TRUE`, prints the final formula used for QC score}
}
\value{
`character`
  A one‐sided formula as a string (e.g. "~ log2SignalDensity + ...").
}
\description{
Returns the right‐hand side of a model formula string based on formula
variables found in the `metadata` of a `SpatialExperiment` object.
}
\examples{
example(checkOutliers)
getModelFormula(metadata(spe)$formula_variables)
}
