% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readXenium.R
\name{computeMissingMetricsXenium}
\alias{computeMissingMetricsXenium}
\title{computeMissingMetricsXenium}
\usage{
computeMissingMetricsXenium(
  polFile,
  colData,
  keepPolygons = FALSE,
  polygonsCol = "polygons"
)
}
\arguments{
\item{polFile}{A character string specifying the file path to the polygon
data.}

\item{colData}{A `DataFrame` containing the `colData` for the Xenium dataset.}

\item{keepPolygons}{A logical value indicating whether to keep the polygon
data in the resulting `colData`. Default is `FALSE`.}

\item{polygonsCol}{character indicating the name of the polygons column to
add into the colData (default is `polygons`).}
}
\value{
A `DataFrame` containing the updated `colData` with computed metrics.
If `keepPolygons` is `TRUE`, the polygon data is also included.
}
\description{
Compute Missing Metrics for Xenium Data

This function computes missing metrics, such as the aspect ratio, from
polygon data in a Xenium dataset and optionally appends the polygon data to
the resulting `colData`.
}
\details{
The function reads the polygon data from the specified file,
computes the aspect ratio for each polygon, and merges these metrics with
the provided `colData`. Optionally, the polygon data can be kept in the
returned `colData`.
}
\examples{
example(readXeniumSPE)
colData(spe) <- computeMissingMetricsXenium(metadata(spe)$polygons,
    colData(spe), keepPolygons=TRUE)
}
