% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMerfish.R
\name{computeMissingMetricsMerfish}
\alias{computeMissingMetricsMerfish}
\title{computeMissingMetricsMerfish}
\usage{
computeMissingMetricsMerfish(
  polFile,
  coldata,
  boundariesType = c("parquet", "HDF5"),
  keepPolygons = FALSE,
  polygonsCol = "polygons",
  useVolume = TRUE
)
}
\arguments{
\item{polFile}{path to the polygon file}

\item{coldata}{`DataFrame` or `data.frame`
Cell metadata with at least a `cell_id` column.}

\item{boundariesType}{`character(1)`
One of `"HDF5"` or `"parquet"`—passed on to
`readPolygonsMerfish()`.}

\item{keepPolygons}{`logical(1)`
If `TRUE`, cbinds the raw polygon `sf` columns onto `coldata`.}

\item{polygonsCol}{character indicating the name of the polygons column to
add into the colData (default is `polygons`).}

\item{useVolume}{`logical(1)` it assigns the area from the "volume" column}
}
\value{
A `DataFrame` (or `data.frame`) with:
  - all columns of `coldata`
  - `um_area`: area of each cell’s polygon
  - `AspectRatio`: width/height aspect ratio
  - (optionally) the polygon geometries
}
\description{
`computeMissingMetricsMerfish()` takes cell metadata and boundary
polygons, calculates per‐cell area and aspect‐ratio, and optionally
appends the raw polygon geometries.
}
\examples{
example(readMerfishSPE)
cd <- computeMissingMetricsMerfish(metadata(spe)$polygons, colData(spe),
    boundariesType="parquet")
colData(spe) <- cd
cd
}
