% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polygons.R
\name{addPolygonsToSPE}
\alias{addPolygonsToSPE}
\title{addPolygonsToSPE}
\usage{
addPolygonsToSPE(spe, polygons, polygonsCol = "polygons")
}
\arguments{
\item{spe}{A `SpatialExperiment` object to which polygons will be added.}

\item{polygons}{An `sf` object containing the polygon data.}

\item{polygonsCol}{character indicating the name of the polygons column to
add into the colData (default is `polygons`).}
}
\value{
The `SpatialExperiment` object with polygons added to the `colData`.
}
\description{
This function adds polygon data to a `SpatialExperiment` object.
}
\examples{
example(readCosmxSPE)
polygons <- readPolygonsCosmx(metadata(spe)$polygons)
spe <- addPolygonsToSPE(spe, polygons)
spe$polygons
}
