% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_overlap_scores}
\alias{plot_overlap_scores}
\title{plot_overlap_scores}
\usage{
plot_overlap_scores(
  df,
  title = "Spatial Overlap Scores",
  out = NULL,
  fontsize = 15
)
}
\arguments{
\item{df}{A data frame with columns pattern1, pattern2 and overlapScore}

\item{title}{The title of the plot}

\item{out}{The output path for the plot}

\item{fontsize}{The font size of the plot}
}
\value{
A ggplot object
}
\description{
Plot the overlap scores between patterns in hotspots
}
\examples{
df <- data.frame(pattern1 = c("pattern1","pattern1","pattern2","pattern2"), 
                 pattern2 = c("pattern1","pattern2","pattern1","pattern2"),
                 overlapScore = c(0.5,0.7,0.3,0.9))
plot_overlap_scores(df)
plot_overlap_scores(df, "Overlap Scores", "overlapScores.png", 15)
}
