% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getInteractingGenes.R
\name{find_all_hotspots}
\alias{find_all_hotspots}
\title{Find hotSpots for all spatial patterns}
\usage{
find_all_hotspots(
  spPatterns,
  params = NULL,
  outlier = "positive",
  nullSamples = 1000,
  includeSelf = TRUE,
  ...
)
}
\arguments{
\item{spPatterns}{A data frame that contains the spatial coordinates
and metrics for spatial features (cell types/cell processes). The column
names must include 'x' and 'y' as well as the spatially varying features.}

\item{params}{a named vector of the optimal sigma and threshold for a
given spatial pattern. The names are should be 'sigmaOpt' and 'threshOpt'.
The default value is NULL.}

\item{outlier}{a character string specifying whether to apply the
outlier threshold to the kernel density distribution in a one-sided manner
(specify 'positive' the default) or in a two sided manner (specify
'two.sided').}

\item{nullSamples}{a numeric values specifying the number of spatial patterns
to randomly sample for a null distribution.}

\item{includeSelf}{a logic value specifying whether to consider the
spatial influence the pattern has on surrounding regions only (set to FALSE),
or whether to also consider the influence of the pattern itself (set to TRUE
, the default).}

\item{...}{Arguments passed to methods}
}
\description{
Convenience function to find hotspots for all spatial patterns
}
