% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findGenesOfInterest.R
\name{.find_genes_of_interest}
\alias{.find_genes_of_interest}
\title{.find_genes_of_interest
Identify genes associated with pattern interaction.
This function identifies genes exhibiting significantly higher values of
testMat in the Interaction region of the two
patterns compared to regions with exclusive influence from either
pattern. It uses Kruskal-Wallis test followed by
posthoc analysis using Dunn's Test to identify the genes.}
\usage{
.find_genes_of_interest(testMat, goodGenes, region, fdr.level=0.05,
       analysis=c("enrichment","overlap"),...)
}
\arguments{
\item{testMat}{A matrix of counts with cells as columns and genes as rows}

\item{goodGenes}{A vector of user specified genes expected to interact
a priori. The default for this is NULL as the function can find these genes
itself}

\item{region}{A data frame of the reference pattern regions that overlap
with the other patterns}

\item{fdr.level}{False Discovery Rate. The default value is 0.05.}

\item{analysis}{a character string that specifies the type of analysis to
carry out, whether overlap or enrichment.}

\item{...}{Additional arguments to be passed to lower level functions}
}
\value{
a list of genes exhibiting significantly higher values of testMat in
the Interaction region of the two #' patterns compared to regions with
exclusive influence from either pattern.
}
\description{
.find_genes_of_interest
Identify genes associated with pattern interaction.
This function identifies genes exhibiting significantly higher values of
testMat in the Interaction region of the two
patterns compared to regions with exclusive influence from either
pattern. It uses Kruskal-Wallis test followed by
posthoc analysis using Dunn's Test to identify the genes.
}
