% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calculate_overlap_undirected}
\alias{calculate_overlap_undirected}
\title{calculate_overlap_undirected}
\usage{
calculate_overlap_undirected(
  hotspots,
  patternList = NULL,
  method = c("Szymkiewicz-Simpson", "Jaccard", "Sorensen-Dice", "Ochiai", "absolute")
)
}
\arguments{
\item{hotspots}{A data frame with columns x, y, barcode and pattern names}

\item{patternList}{A character vector of pattern names to calculate overlap
scores for}

\item{method}{The method to calculate overlap scores. Options are
"Szymkiewicz-Simpson", "Jaccard", "Sorensen-Dice", "Ochiai" and "absolute"}
}
\value{
A data frame with columns pattern1, pattern2 and overlapScore
}
\description{
Calculate the overlap scores between patterns in hotspots
}
\details{
The function calculates the overlap scores between patterns hotspots
using the specified method. The default method is "Szymkiewicz-Simpson"
overlap coefficient.
}
\examples{
hotspots <- data.frame(x = c(1,2,3,4,5),
                        y = c(1,2,3,4,5),
                        barcode = c("A","B","C","D","E"),
                        pattern1 = c("pattern1",NA,"pattern1",NA,"pattern1"),
                        pattern2 = c("pattern2","pattern2",NA,NA,"pattern2"))
calculate_overlap_undirected(hotspots)   
calculate_overlap_undirected(hotspots, c("pattern1","pattern2"))
}
