% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calculate_gene_set_score}
\alias{calculate_gene_set_score}
\title{calculate_gene_set_score}
\usage{
calculate_gene_set_score(
  IMscores,
  gene_sets,
  weighted = TRUE,
  method = c("geometric_mean", "arithmetic_mean")
)
}
\arguments{
\item{IMscores}{A matrix of interaction scores}

\item{gene_sets}{A list of gene sets, where each set is a vector of gene names}

\item{weighted}{Logical; if TRUE, gene scores are weighted by their occurrence in multiple gene sets}

\item{method}{Character; specifies the aggregation method for gene set scores. Options are "geometric_mean" or "arithmetic_mean"}
}
\value{
A matrix of mean interaction scores for genes in each gene set, with
attributes for log p-value sums and number of genes for later fisher combination
}
\description{
Calculate the mean interaction score for a set of genes
}
\details{
This function computes mean interaction scores for given gene sets across cell interactions.
It supports both geometric and arithmetic means, and can weight gene contributions based on their presence in multiple gene sets.
}
