% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataImport.R
\name{readExperiment}
\alias{readExperiment}
\title{Read and Process the DDA experiment.}
\usage{
readExperiment(
  fileTable,
  localProbCut = 0.75,
  scoreDiffCut = 5,
  fdrCut = 0.1,
  scoreCut = 10,
  pepNumCut = 1,
  ifLFQ = TRUE,
  annotation_col = c(),
  verbose = FALSE
)
}
\arguments{
\item{fileTable}{A \code{data.frame} containing information about the input
files, including searchType, id, sample, and other annotations.}

\item{localProbCut}{\code{Numeric}, local probability cutoff for filtering
phosphoproteomic data. Default is 0.75.}

\item{scoreDiffCut}{\code{Numeric}, score difference cutoff for filtering
phosphoproteomic data. Default is 5.}

\item{fdrCut}{\code{Numeric}, false discovery rate cutoff for filtering
proteomic data. Default is 0.1.}

\item{scoreCut}{\code{Numeric}, score cutoff for filtering proteomic data.
Default is 10.}

\item{pepNumCut}{\code{Numeric}, peptide number cutoff for filtering
proteomic data. Default is 1.}

\item{ifLFQ}{\code{Logical}, whether to use LFQ quantification for proteomic
data. Default is \code{TRUE}.}

\item{annotation_col}{A \code{character} vector specifying additional columns
to be included in the sample annotation. Default is an empty vector.}

\item{verbose}{\code{Logical} value indicating whether to print detailed
information. Default is \code{FALSE}.}
}
\value{
A \code{MultiAssayExperiment} object containing the processed
phosphoproteomic and proteomic data from a DDA experiment.
}
\description{
\code{readExperiment} reads and processes DDA (Data-Dependent Acquisition)
phosphoproteomic and proteomic data from a given file table, and returns a
\code{MultiAssayExperiment} object.
}
\details{
The function performs the following steps:
\itemize{
  \item Reads and processes the phosphoproteomic data using the
  \code{readPhosphoExperiment} function.
  \item Reads and processes the proteomic data using the
  \code{readProteomeExperiment} function.
  \item Prepares the sample annotation table.
  \item Constructs and returns a \code{MultiAssayExperiment} object
  containing the processed data.
}
}
\examples{
# Example usage:
file1 <- system.file("extdata", "phosDDA_1.xls", package = "SmartPhos")
file2 <- system.file("extdata", "proteomeDDA_1.xls", package = "SmartPhos")
# Create fileTable
fileTable <- data.frame(
  searchType = c("phosphoproteome", "proteome"),
  fileName = c(file1, file2),
  sample = c("Sample1", "sample1"),
  id = c("s1", "s2")
)
# Call the function
readExperiment(fileTable, localProbCut = 0.75, scoreDiffCut = 5,
fdrCut = 0.1, scoreCut = 10, pepNumCut = 1, ifLFQ = TRUE,
annotation_col = c("id"))

}
