% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization_correction.R
\name{plotLogRatio}
\alias{plotLogRatio}
\title{Plot Log Ratio of PP/FP (Phosphoproteome to Full Proteome) intensities}
\usage{
plotLogRatio(maeData, normalization = FALSE)
}
\arguments{
\item{maeData}{A \code{MultiAssayExperiment} object containing
phosphoproteome and full proteome data.}

\item{normalization}{A \code{logical} value indicating whether to perform
normalization. Default is \code{FALSE}.}
}
\value{
A \code{ggplot2} object representing the boxplot of the log2 ratios.
}
\description{
\code{plotLogRatio} generates a boxplot of the log2 ratio of intensities of
phosphoproteome to full proteome data from a \code{MultiAssayExperiment}
object.
}
\examples{
# Load multiAssayExperiment object
data("dia_example")
# Call the function
plotLogRatio(dia_example, normalization = TRUE)

}
