% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genewiseAssociations.R
\name{genewiseAssociation}
\alias{genewiseAssociation}
\title{Generate genewise association between genes and peaks}
\usage{
genewiseAssociation(
  associationBy = "distance",
  geneCoordinates = NULL,
  geneNames = NULL,
  peakCoordinates = NULL,
  peakNames = NULL,
  distance = 50000,
  givenRegions = NULL,
  strand1 = NULL,
  strand2 = NULL,
  outFile = "genewiseAssociation"
)
}
\arguments{
\item{associationBy}{Can be "distance", "regions", or "DNAinteractions"}

\item{geneCoordinates}{Gene coordinates in granges format}

\item{geneNames}{Gene names can be provided by the user}

\item{peakCoordinates}{Peak coordinates in granges format}

\item{peakNames}{Peak names can be provided by the user}

\item{distance}{The maximum distance to associate peaks to genes. default 50K}

\item{givenRegions}{granges coordinates of given regions (ex. TAD or loops)}

\item{strand1}{granges of DNA strand1 linked to DNA strand2}

\item{strand2}{granges of DNA strand2 linked to DNA strand1}

\item{outFile}{The name of the output folder (default "genewiseAssociation")}
}
\value{
A vector of portions of linked genes and linked peaks
}
\description{
Get genomic coordinates of a set of genes and a set of peaks

associate them by a fixed distance (default 50K nt). It also

associate genes and peaks for provided DNA-DNA interaction from

a dataset like HiC. This function can also associate genes and

user provided regions (ex. TADs, subTADs, etc). It generates

three tables: Gene table, peak table, and Gene-Peak association

table.
}
\examples{
geneFile=system.file("extdata", "gene_expression.tsv", package="Site2Target")
geneCoords <- Table2Granges(geneFile)
geneTable <- read.table(geneFile, header=TRUE)

geneDEIndices <- which((abs(geneTable$logFC)>1)==TRUE)
indicesLen <- length(geneDEIndices)
if(indicesLen >0)
{
    geneTable <- geneTable[geneDEIndices,]
    geneCoords <- geneCoords[geneDEIndices]
}
geneDENames <- geneTable$name
geneDElogFC <- geneTable$logFC
geneCoordsDE <- geneCoords

tfFile =system.file("extdata", "MEIS_binding.tsv", package="Site2Target")
TFCoords <- Table2Granges(tfFile)
tfTable <- read.table(tfFile, header=TRUE)

stats <-
genewiseAssociation(associationBy="distance",
                    geneCoordinates=geneCoordsDE,
                    geneNames=geneDENames,
                    peakCoordinates=TFCoords,
                    distance=50000,
                    outFile="Gene_TF_50K")
stats
}
