% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakwiseAssociations.R
\name{extendSitesInGivenRegions}
\alias{extendSitesInGivenRegions}
\title{Extend sites given regions boundaries}
\usage{
extendSitesInGivenRegions(givenRegions, sites, distance = 1e+05)
}
\arguments{
\item{givenRegions}{granges coordinates of given regions (ex. TAD or loops)}

\item{sites}{granges coordinates of sites}

\item{distance}{the maximum distance to associate sites to regions}
}
\value{
A granges of the extended sites in given regions
}
\description{
Get sites and given regions (ex. TADs or loops) coordinates.

It extends sites in a give region using a distance function
}
\examples{
tfFile =system.file("extdata", "MEIS_binding.tsv", package="Site2Target")
TFCoords <- Table2Granges(tfFile)

TADsFile =system.file("extdata", "TADs.tsv",package="Site2Target")
TADs <- Table2Granges(TADsFile)

extendSitesInGivenRegions(TADs, TFCoords)

}
