% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genewiseAssociations.R
\name{addRelation2geneWiseAssociation}
\alias{addRelation2geneWiseAssociation}
\title{Add a relation column to gene-peak interaction table}
\usage{
addRelation2geneWiseAssociation(
  strand1 = NULL,
  strand2 = NULL,
  columnName,
  column,
  inFile = "geneWiseAssociation",
  outFile = "geneWiseAssociation"
)
}
\arguments{
\item{strand1}{granges of DNA strand1 linked to DNA strand2}

\item{strand2}{granges of DNA strand2 linked to DNA strand1}

\item{columnName}{Column name that should be added to the interaction table}

\item{column}{Column values that should be added to the interaction table}

\item{inFile}{The name of the input folder (default "genewiseAssociation")}

\item{outFile}{The name of the output folder (default "genewiseAssociation")}
}
\value{
No value would be returned just a column be added to link table
}
\description{
Get coordinates of interactions (ex. HiC interactions) and a

column of interaction values (ex. HiC intensities ) and add them

as a column to gene-peak interaction table.
}
\examples{
geneFile=system.file("extdata", "gene_expression.tsv", package="Site2Target")
geneCoords <- Table2Granges(geneFile)
geneTable <- read.table(geneFile, header=TRUE)

geneDEIndices <- which((abs(geneTable$logFC)>1)==TRUE)
indicesLen <- length(geneDEIndices)
if(indicesLen >0)
{
    geneTable <- geneTable[geneDEIndices,]
    geneCoords <- geneCoords[geneDEIndices]
}
geneDENames <- geneTable$name
geneDElogFC <- geneTable$logFC
geneCoordsDE <- geneCoords

tfFile =system.file("extdata", "MEIS_binding.tsv", package="Site2Target")
TFCoords <- Table2Granges(tfFile)
tfTable <- read.table(tfFile, header=TRUE)

stats <-
genewiseAssociation(associationBy="distance",
                    geneCoordinates=geneCoordsDE,
                    geneNames=geneDENames,
                    peakCoordinates=TFCoords,
                    distance=50000,
                    outFile="Gene_TF_50K")
stats

HiCFile =system.file("extdata", "HiC_intensities.tsv", package="Site2Target")
HiCstr1 <- Table2Granges(HiCFile, chrColName="Strand1_chr",
                     startColName="Strand1_start", endColName="Strand1_end")
HiCstr2 <- Table2Granges(HiCFile, chrColName="Strand2_chr",
                     startColName="Strand2_start", endColName="Strand2_end")
HiCTable <- read.table(HiCFile, header=TRUE)
HiCintensities <- HiCTable$intensities

addRelation2geneWiseAssociation(strand1=HiCstr1, strand2=HiCstr2,
     columnName="HiC_Intensities", column=HiCintensities,
     inFile="Gene_TF_50K", outFile="Gene_TF_50K")
}
\seealso{
\code{\link{genewiseAssociation}}
}
