% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotScoreDistribution.R
\name{plotScoreDistribution}
\alias{plotScoreDistribution}
\title{Plot score distributions}
\usage{
plotScoreDistribution(
  results,
  show = NULL,
  labels.use = NULL,
  references = NULL,
  scores.use = NULL,
  calls.use = 0,
  pruned.use = NULL,
  size = 0.5,
  ncol = 5,
  dots.on.top = TRUE,
  this.color = "#F0E442",
  pruned.color = "#E69F00",
  other.color = "gray60",
  show.nmads = 3,
  show.min.diff = NULL,
  grid.vars = list()
)
}
\arguments{
\item{results}{A \link[S4Vectors]{DataFrame} containing the output from \code{\link{SingleR}}, \code{\link{classifySingleR}}, or \code{\link{combineRecomputedResults}}.}

\item{show}{Deprecated, use \code{\link{plotDeltaDistribution}} instead for \code{show!="scores"}.}

\item{labels.use}{Character vector specifying the labels to show in the plot facets.
Defaults to all labels in \code{results}.}

\item{references}{Integer scalar or vector specifying the references to visualize.
This is only relevant for combined results, see Details.}

\item{scores.use}{Deprecated, see \code{references}.}

\item{calls.use}{Deprecated and ignored.}

\item{pruned.use}{Deprecated and ignored.}

\item{size}{Numeric scalar to set the size of the dots.}

\item{ncol}{Integer scalar to set the number of labels to display per row.}

\item{dots.on.top}{Logical scalar specifying whether cell dots should be plotted on top of the violin plots.}

\item{this.color}{String specifying the color for cells that were assigned to the label.}

\item{pruned.color}{String specifying the color for cells that were assigned to the label but pruned.}

\item{other.color}{String specifying the color for other cells not assigned to the label.}

\item{show.nmads, show.min.diff}{Deprecated, use \code{\link{plotDeltaDistribution}} instead.}

\item{grid.vars}{Named list of extra variables to pass to \code{\link[gridExtra]{grid.arrange}},
used to arrange the multiple plots generated when \code{references} is of length greater than 1.}
}
\value{
If \code{references} specifies a single set of scores,
a \link[ggplot2]{ggplot} object is returned showing the scores in violin plots.

If \code{references} specifies multiple scores for a combined result,
multiple ggplot objects are generated in a grid on the current graphics device.

If \code{references} specifies multiple scores and \code{grid.vars=NULL},
a list is returned containing the ggplot objects for manual display.
}
\description{
Plot the distribution of assignment scores across all cells assigned to each reference label.
}
\details{
This function creates jitter and violin plots showing assignment scores for all cells across one or more labels.
Each facet represents a label in \code{labels.use} and contains three violin plots:
\itemize{
\item \dQuote{Assigned}, containing scores for all cells assigned to that label.
Colored according to \code{this.color}.
\dQuote{Pruned}, containing scores for all cells assigned to that label but pruned out, e.g., by \code{\link{pruneScores}}.
Colored according to \code{pruned.color}, and can be omitted by setting \code{pruned.color=NA}.
\item \dQuote{Other}, containing the scores for all cells assigned to other labels.
Colored according to \code{other.color}.
}
The expectation is that the former is higher than the latter,
though the deltas generated by \code{\link{plotDeltaDistribution}} are often more informative in this regard.

For combined results (see \code{?\link{combineRecomputedResults}}),
this function can show both the combined and individual scores.
This is done using the \code{references} argument,
entries of which refer to columns of \code{results$orig.results} if positive or to the combined results if zero.
For example:
\itemize{
\item If we set \code{references=2}, we will plot the scores from the second individual reference.
\item If we set \code{references=1:2}, 
we will plot the scores from first and second references (in separate plots) faceted by their corresponding labels.
\item By default, the function will create a separate plot for the combined scores and each individual reference,
equivalent to \code{references=0:N} for \code{N} individual references.
}
}
\examples{
example(SingleR, echo=FALSE)

# To show the distribution of scores grouped by label:
plotScoreDistribution(results = pred)

# We can display a particular label using the label
plotScoreDistribution(results = pred,
    labels.use = "B")

# For multiple references, default output will contain separate plots for
# each original reference as well as for the the combined scores.
example(combineRecomputedResults, echo = FALSE)
plotScoreDistribution(results = combined)

# 'references' specifies which original results to plot distributions for.
plotScoreDistribution(results = combined, references = 0)
plotScoreDistribution(results = combined, references = 1:2)

# Tweaking the grid arrangement:
plotScoreDistribution(combined, grid.vars = list(ncol = 2))

}
\seealso{
\code{\link{pruneScores}}, to remove low-quality labels based on the scores.

\code{\link{plotDeltaDistribution}} and \code{\link{plotScoreHeatmap}}, for alternative diagnostic plots.
}
\author{
Daniel Bunis and Aaron Lun
}
