% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMarkerHeatmap.R
\name{plotMarkerHeatmap}
\alias{plotMarkerHeatmap}
\alias{configureMarkerHeatmap}
\title{Plot a heatmap of the markers for a label}
\usage{
plotMarkerHeatmap(
  results,
  test,
  label,
  other.labels = NULL,
  assay.type = "logcounts",
  display.row.names = NULL,
  use.pruned = FALSE,
  order.by.effect = "cohens.d",
  order.by.summary = "min.rank",
  top = 20,
  num.threads = bpnworkers(BPPARAM),
  BPPARAM = SerialParam(),
  ...
)

configureMarkerHeatmap(
  results,
  test,
  label,
  other.labels = NULL,
  assay.type = "logcounts",
  use.pruned = FALSE,
  order.by.effect = "cohens.d",
  order.by.summary = "min.rank",
  num.threads = 1
)
}
\arguments{
\item{results}{A \link[S4Vectors]{DataFrame} containing the output from \code{\link{SingleR}}, \code{\link{classifySingleR}}, or \code{\link{combineRecomputedResults}}.}

\item{test}{A numeric matrix of log-normalized expression values where rows are genes and columns are cells.
Each row should be named with the same gene name that was used to compute \code{results}.

Alternatively, a \link[SummarizedExperiment]{SummarizedExperiment} object containing such a matrix.}

\item{label}{String specifying the label of interest.}

\item{other.labels}{Character vector specifying the other labels to be compared to \code{label} when finding interesting markers.
Defaults to all available labels.}

\item{assay.type}{Integer scalar or string specifying the matrix of expression values to use if \code{test} is a \link[SummarizedExperiment]{SummarizedExperiment}.}

\item{display.row.names}{Character vector of length equal to the number of rows of \code{test},
containing the names of the features to show on the heatmap (e.g., to replace IDs with symbols).
If \code{NULL}, the existing row names of \code{test} are used.}

\item{use.pruned}{Logical scalar indicating whether the pruned labels should be used instead.}

\item{order.by.effect}{String specifying the effect size from \code{\link[scrapper]{scoreMarkers}} with which to sort for interesting markers.}

\item{order.by.summary}{String specifying the summary statistic from \code{\link[scrapper]{scoreMarkers}} with which to sort for interesting markers.}

\item{top}{Integer scalar indicating the top most interesting markers to show in the heatmap.}

\item{num.threads}{Integer scalar specifying the number to threads to use.}

\item{BPPARAM}{Deprecated, use \code{num.threads} instead.}

\item{...}{Additional parameters for heatmap control passed to \code{\link[pheatmap]{pheatmap}}.}
}
\value{
For \code{plotMarkerHeatmap}, the output of \code{\link[pheatmap]{pheatmap}} is returned showing the heatmap on the current graphics device.

For \code{configureMarkerHeatmap}, a list is returned containing:
\itemize{
\item \code{rows}, an integer vector of row indices for the markers of \code{label}, ordered from most to least interesting.
\item \code{columns}, an integer vector of column indices to show in the heatmap.
This is ordered by the predicted labels so that cells assigned to the same label are contiguous.
\item \code{predictions}, a character vector of predicted labels for cells to be shown in the heatmap.
Each entry corresponds to an entry of \code{columns}.
The labels in this vector are guaranteed to be sorted.
}
}
\description{
Create a heatmap of the log-normalized expression for the most interesting markers of a particular label.
}
\details{
The \code{plotMarkerHeatmap} function creates a heatmap where each row is a marker gene for \code{label} and each column is a cell in the test dataset.
The aim is to check the effectiveness of the reference-derived markers for distinguishing between labels in the test dataset.
\dQuote{Interesting} markers should show strong upregulation in cells assigned to \code{label} compared to cells assigned to all \code{other.labels}. 
We identify such markers by scoring all reference-derived markers with \code{\link[scrapper]{scoreMarkers}} on the \code{test} expression.
The \code{top} markers based on the specified \code{order.by.*} fields are shown in the heatmap.
If only one label is present, markers are ranked by average abundance intead. 

The \code{configureMarkerHeatmap} function performs all the calculations underlying \code{plotMarkerHeatmap}.
This can be used to apply the same general approach with other plots, e.g., using functions from \pkg{scuttle} or \pkg{dittoSeq}.
}
\examples{
# Running the SingleR() example.
example(SingleR, echo=FALSE)

plotMarkerHeatmap(pred, test, pred$labels[1])
plotMarkerHeatmap(pred, test, pred$labels[1], use.pruned=TRUE)
plotMarkerHeatmap(pred, test, pred$labels[1], order.by.effect="auc")

# Manually configuring a simpler heatmap by label:
config <- configureMarkerHeatmap(pred, test, pred$labels[1])
mat <- assay(test, "logcounts")[head(config$rows, 20), config$columns]
aggregated <- scuttle::summarizeAssayByGroup(mat, config$predictions)
pheatmap::pheatmap(assay(aggregated), cluster_col=FALSE)

}
\author{
Aaron Lun
}
