% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.r
\name{StateQuantificationPlot}
\alias{StateQuantificationPlot}
\title{Plot states quantification bar}
\usage{
StateQuantificationPlot(SortedReads, states)
}
\arguments{
\item{SortedReads}{Sorted reads object as returned by SortReads function}

\item{states}{either SingleTFStates() or TFPairStates()}
}
\value{
Bar plot quantifying states
}
\description{
Plot states quantification bar
}
\examples{

library(GenomicRanges)

RegionOfInterest = GRanges("chr12", IRanges(20464551, 20465050))
Methylation = qs::qread(system.file(
    "extdata", "Methylation_3.qs", package="SingleMoleculeFootprinting"
    ))
TFBSs = qs::qread(system.file("extdata", "TFBSs_3.qs", package="SingleMoleculeFootprinting"))
SortedReads = SortReadsBySingleTF(MethSM = Methylation[[2]], TFBS = TFBSs)

StateQuantificationPlot(SortedReads = SortedReads, states = SingleTFStates())

}
