% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_molecule_sorting.r
\name{SortReads}
\alias{SortReads}
\title{Sort reads by single TF}
\usage{
SortReads(MethSM, BinsCoordinates, coverage = NULL)
}
\arguments{
\item{MethSM}{Single molecule matrix}

\item{BinsCoordinates}{IRanges object of absolute coordinates for sorting bins}

\item{coverage}{integer. Minimum number of reads covering all sorting bins for sorting to be performed}
}
\value{
list of sorted reads
}
\description{
Sort reads by single TF
}
\examples{

library(IRanges)

Methylation = qs::qread(system.file("extdata", "Methylation_3.qs", 
package="SingleMoleculeFootprinting"))
TFBS = qs::qread(system.file("extdata", "TFBSs_3.qs", 
package="SingleMoleculeFootprinting"))

bins = list(c(-35,-25), c(-15,15), c(25,35))
TFBS_center = start(TFBS) + (end(TFBS)-start(TFBS))/2
BinsCoordinates = IRanges(
start = c(TFBS_center+bins[[1]][1], TFBS_center+bins[[2]][1], TFBS_center+bins[[3]][1]),
end = c(TFBS_center+bins[[1]][2], TFBS_center+bins[[2]][2], TFBS_center+bins[[3]][2])
)

SortedReads = SortReads(Methylation[[2]]$SMF_MM_TKO_DE_, BinsCoordinates, coverage = 20)

}
