% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FootprintCharter_plotting.r
\name{Plot_FootprintCharter_SM}
\alias{Plot_FootprintCharter_SM}
\title{Plot single molecule heatmaps of footprint detection results}
\usage{
Plot_FootprintCharter_SM(footprints.df, RegionOfInterest, partitions.order)
}
\arguments{
\item{footprints.df}{data.frame of footprints as returned by FootprintCharter()}

\item{RegionOfInterest}{GRanges interval to plot}

\item{partitions.order}{integer vector specifying the order in which to plot partitions}
}
\description{
Plot single molecule heatmaps of footprint detection results
}
\examples{

Methylation = qs::qread(system.file(
    "extdata", "Methylation_4.qs", package="SingleMoleculeFootprinting"
    ))
MethSM = Methylation[[2]]
RegionOfInterest = GenomicRanges::GRanges("chr6", IRanges::IRanges(88106000, 88106500))
RegionOfInterest = IRanges::resize(RegionOfInterest, 80, "center")

FootprintCharter(
  MethSM = MethSM,
  RegionOfInterest = RegionOfInterest,
  coverage = 30,
  k = 16,
  n = 5,
  TF.length = c(5,75),
  nucleosome.length = c(120,1000),
  cytosine.coverage.thr = 5,
  verbose = TRUE
  ) -> FC_results
  
partitions.order = c(3,1,2,5,6,7,4,8)
Plot_FootprintCharter_SM(
  footprints.df = FC_results$footprints.df, 
  RegionOfInterest = IRanges::resize(RegionOfInterest, 500, "center"), 
  partitions.order = partitions.order
  )

}
