% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.r
\name{PlotSingleMoleculeStack}
\alias{PlotSingleMoleculeStack}
\title{Plot single molecule stack}
\usage{
PlotSingleMoleculeStack(MethSM, RegionOfInterest)
}
\arguments{
\item{MethSM}{Single molecule methylation matrix}

\item{RegionOfInterest}{GRanges interval to plot}
}
\description{
Plot single molecule stack
}
\examples{

library(GenomicRanges)

RegionOfInterest = GRanges("chr12", IRanges(20464551, 20465050))
Methylation = qs::qread(system.file("extdata", "Methylation_3.qs", 
package="SingleMoleculeFootprinting"))

PlotSingleMoleculeStack(MethSM = Methylation[[2]], RegionOfInterest = RegionOfInterest)

}
