% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FootprintCharter.r
\name{FootprintCharter}
\alias{FootprintCharter}
\title{Run FootprintCharter}
\usage{
FootprintCharter(
  MethSM,
  RegionOfInterest,
  RegionOfInterest_ext = IRanges::resize(RegionOfInterest, 500, "center"),
  TFBSs = NULL,
  coverage = 30,
  k = 16,
  n = 5,
  TF.length = c(5, 75),
  nucleosome.length = c(120, 1000),
  cytosine.coverage.thr = 5,
  verbose = TRUE
)
}
\arguments{
\item{MethSM}{Single molecule matrix list as returned by CallContextMethylation()}

\item{RegionOfInterest}{GRanges of coordinates to analyse}

\item{RegionOfInterest_ext}{RegionOfInterest to be resized, defaults to IRanges::resize(RegionOfInterest, 500, "center")}

\item{TFBSs}{TFBSs annotation. Used to annotate TF footprints downstream of footprint detection.}

\item{coverage}{minimum number of molecules required. Defaults to 30}

\item{k}{number of partitions required. Defaults to 16. Will be dynamically reduced according to minimum number of molecules reqiured (n, see below)}

\item{n}{minimum number of molecules required per partition}

\item{TF.length}{vector of two integers for footprint length bounds. Defaults to c(5,75).}

\item{nucleosome.length}{vector of two integers for footprint length bounds. Defaults to c(120,1000).}

\item{cytosine.coverage.thr}{Cytosine coverage threshold for footprint detection. Individual cytosines will be discarded, not whole footprints. Defaults to 5.}

\item{verbose}{Defaults to TRUE}
}
\description{
Run FootprintCharter
}
\examples{

Methylation = qs::qread(
  system.file("extdata", "Methylation_4.qs", package="SingleMoleculeFootprinting"
  ))
MethSM = Methylation[[2]]
RegionOfInterest = GenomicRanges::GRanges("chr6", IRanges::IRanges(88106000, 88106500))
RegionOfInterest = IRanges::resize(RegionOfInterest, 80, "center")

FootprintCharter(
  MethSM = MethSM,
  RegionOfInterest = RegionOfInterest,
  coverage = 30,
  k = 16,
  n = 5,
  TF.length = c(5,75),
  nucleosome.length = c(120,1000),
  cytosine.coverage.thr = 5,
  verbose = TRUE
  ) -> FC_results
  
}
