% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylation_calling.r
\name{CollapseStrandsSM}
\alias{CollapseStrandsSM}
\title{Collapse strands in single molecule matrix}
\usage{
CollapseStrandsSM(MethSM, context, genome, chr)
}
\arguments{
\item{MethSM}{Single molecule matrix}

\item{context}{"GC" or "CG". Broad because indicates just the directionality of collapse.}

\item{genome}{BSgenome}

\item{chr}{Chromosome, MethSM doesn't carry this info}
}
\value{
Strand collapsed MethSM
}
\description{
The idea here is that (regardless of context) if a C is on the - strand, calling getSeq on that coord (N.b. unstranded, that's the important bit) will give a "G', a "C" if it's a + strand.
}
\examples{

Methylation = qs::qread(system.file(
    "extdata", "Methylation_3.qs", package="SingleMoleculeFootprinting"
    ))
CollapseStrandsSM(
    Methylation[[2]][[1]], "GC", 
    BSgenome.Mmusculus.UCSC.mm10::BSgenome.Mmusculus.UCSC.mm10, "chr19"
    )

}
