% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methylation_calling.r
\name{CallContextMethylation}
\alias{CallContextMethylation}
\title{Call Context Methylation}
\usage{
CallContextMethylation(
  sampleFile,
  samples,
  genome,
  RegionOfInterest,
  coverage = 20,
  ConvRate.thr = NULL,
  returnSM = TRUE,
  clObj = NULL,
  verbose = FALSE
)
}
\arguments{
\item{sampleFile}{QuasR pointer file}

\item{samples}{vector of unique sample names corresponding to the SampleName field from the sampleFile}

\item{genome}{BSgenome}

\item{RegionOfInterest}{GenimocRange representing the genomic region of interest}

\item{coverage}{coverage threshold as integer for least number of reads to cover a cytosine for it to be carried over in the analysis. Defaults to 20.}

\item{ConvRate.thr}{Convesion rate threshold. Double between 0 and 1, defaults to NULL. To skip this filtering step, set to NULL. For more information, check out the details section.}

\item{returnSM}{whether to return the single molecule matrix, defaults to TRUE}

\item{clObj}{cluster object for parallel processing of multiple samples. For now only used by qMeth call for bulk methylation. Should be the output of a parallel::makeCluster() call}

\item{verbose}{whether to print out messages while executing. Defaults to FALSE}
}
\value{
List with two Granges objects: average methylation call (GRanges) and single molecule methylation call (matrix)
}
\description{
Can deal with multiple samples
}
\details{
The ConvRate.thr argument should be used with care as it could create biases (e.g. when only one C out of context is present) while generally only marginally cleaning up the data.
}
\examples{

sampleFile = NULL
if(!is.null(sampleFile)){
Methylation <- CallContextMethylation(
  sampleFile = sampleFile, 
  samples = samples, 
  genome = BSgenome.Mmusculus.UCSC.mm10, 
  RegionOfInterest = RegionOfInterest,
  coverage = 20, 
  returnSM = TRUE,
  ConvRate.thr = NULL,
  clObj = NULL
)
}

}
