% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{cellNetBubblePlot}
\alias{cellNetBubblePlot}
\title{Overview of cellular networks}
\usage{
cellNetBubblePlot(
  obj,
  selected.populations = NULL,
  genes.to.count = NULL,
  only.R.in.genes = TRUE,
  use.proportions = FALSE,
  low.color = "gray25",
  high.color = "firebrick1"
)
}
\arguments{
\item{obj}{A SCSRNet or SCSRNoNet object.}

\item{selected.populations}{A vector of cell population names
to consider in the plot. By default, all the populations are
considered.}

\item{genes.to.count}{A vector of gene names for counting or enrichment
analysis.}

\item{only.R.in.genes}{A logical indicating whether \code{genes.to.count}
should be regarded as containing receptor gene names only.}

\item{use.proportions}{A logical to choose between representing the
proportion of genes in \code{genes.to.count} or its enrichment.}

\item{low.color}{The color to be used when no gene list is provided
or when the proportion of genes in \code{genes.to.count} is 0.}

\item{high.color}{The color for maximum proportion or best enrichment
P-value.}
}
\value{
A BSRDataModel object containing the smoothed ncounts.
}
\description{
Overview of cellular networks
}
\details{
A matrix dot plot is generated to represent how much each pair of
cell populations interact including autocrine interactions when
available.

By default, the plot only reports the number of interactions, but it is
possible to provide a list of genes of interest (\code{genes.to.count}
parameter). One option in this
case is to provide receptors involved in specific signaling whose
abundance is to be illustrated on top of the number of interactions. For
this, \code{only.R.in.genes} must be set to TRUE, the default. If not,
then only interactions with both the ligand and the receptor in
\code{genes.to.count} are considered. This may enable more specific
counting. Lastly, it is possible to choose between color-coding the
proportion of interactions with receptor or both receptor and ligand in
\code{genes.to.count}, or to perform an enrichment analysis. In the
last case, the color-code is based on -log10(P-values).
}
\examples{
print("cellNetBubblePlot")
if (FALSE) {
    cellBubblePlot(scsrcn)
}
}
