% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCSRNet-class.R
\docType{class}
\name{SCSRNet-class}
\alias{SCSRNet-class}
\title{SingleCellSignalR cellular network object}
\description{
An S4 class to represent data and inferences related to a single-cell
data set and aimed at predicting ligand-receptor interactions. Both
autocrine and paracrine interactions can be inferred and explored.
}
\details{
This class is a container for all the data and inferences
related to a given single-cell project. Inferred interactions in
\code{paracrines} and \code{autocrines} can be further reduced to
eliminate redundancies such as multiple downstream pathways for the same
ligand-receptor interaction. See reduction functions
\code{"\link[=SCSRNet-class]{reduceToBestPathway}"},
\code{"\link[=SCSRNet-class]{reduceToLigand}"},
\code{"\link[=SCSRNet-class]{reduceToReceptor}"} and
\code{"\link[=SCSRNet-class]{reduceToPathway}"}.
}
\section{Slots}{

\describe{
\item{\code{bsrdm.comp}}{A BulkSignalR BSRDataModelComp object containing
the expression matrix data as well as the comparisons between cell
populations.}

\item{\code{populations}}{A vector defining the cell population to which
each individual cell belongs to. The length of this vector must
be equal to the number of columns of the expression matrix.}

\item{\code{paracrines}}{A list of BulkSignalR BSRInferenceComp objects
containing all the paracrine ligand-receptor interactions between
all the possible pairs of cell populations.}

\item{\code{autocrines}}{A list of BulkSignalR BSRInferenceComp objects
containing all the autocrine ligand-receptor interactions for
each cell population.}

\item{\code{inf.param}}{Inference parameters.}
}}

\examples{
print("Create SCSRNet object:")
data(example_dataset, package = "SingleCellSignalR")
mat <- log1p(data.matrix(example_dataset[, -1])) / log(2)
rownames(mat) <- example_dataset[[1]]
rme <- rowMeans(mat)
mmat <- mat[rme > 0.05, ]
d <- dist(t(mmat))
h <- hclust(d, method = "ward.D")
pop <- paste0("pop_", cutree(h, 5))
scsrcn <- SCSRNet(mat,
    populations = pop, normalize = FALSE,
    method = "log-only", log.transformed = TRUE
)
}
