% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAlleleCounts.R
\name{read_allele_counts}
\alias{read_allele_counts}
\title{Reading in allele quantification data into SingleCellAlleleExperiment object}
\usage{
read_allele_counts(
  samples_dir,
  sample_names = names(samples_dir),
  filter_mode = c("no", "yes", "custom"),
  lookup_file = lookup,
  barcode_file = "cells_x_genes.barcodes.txt",
  gene_file = "cells_x_genes.genes.txt",
  matrix_file = "cells_x_genes.mtx",
  filter_threshold = NULL,
  log = FALSE,
  gene_symbols = FALSE,
  verbose = FALSE,
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{samples_dir}{A character string determining the path to one directory
containing input files.}

\item{sample_names}{A character string for a sample identifier.
Can be used to describe the used dataset or sample.}

\item{filter_mode}{A vector containing three character strings that describe
different options for filtering. The value \code{"yes"} uses the inflection point
of the knee plot to filter out low-quality cells.
The default value \code{"no"} performs filtering on a \code{threshold=0}.
The value \code{"custom"} allows for setting a custom threshold in
the \code{filter_threshold} parameter.}

\item{lookup_file}{A character string determining the path to the lookup table.}

\item{barcode_file}{A character string determining the name of the file
containing the barcode identifiers.}

\item{gene_file}{A character string determining the name of the file
containing the feature identifiers.}

\item{matrix_file}{A character string determining the name of the file
containing the count matrix.}

\item{filter_threshold}{An integer value used as a threshold for filtering
low-quality barcodes/cells. Standard value is \code{NULL} when using \code{filter = c("yes", "no")}.
Value must be provided when using \code{filter = "custom"}.}

\item{log}{A logical parameter to decide if logcounts assay should be computed
based on library factors computed with \code{scuttle::computeLibraryFactors()}.}

\item{gene_symbols}{A logical parameter to decide whether to compute additional
gene gene symbols in case the raw data only contains ENSEMBL gene identifiers.}

\item{verbose}{A logical parameter to decide if additional runtime-messages
should be shown during function execution. Use \code{FALSE} if no info
runtime-messages should be shown (default), and \code{TRUE} for showing runtime-messages.}

\item{BPPARAM}{A BiocParallelParam object specifying how loading should be
parallelized for multiple samples.}
}
\value{
A SingleCellAlleleExperiment object.
}
\description{
Main read in function for reading in allele quantification data and
loading the data into an \code{SingleCellAlleleExperiment} object.
}
\details{
The SingleCellAlleleExperiment data structure serves as a data representation
for data generated with the \code{scIGD} workflow.
This workflow allows for the quantification of expression and interactive
exploration of donor-specific alleles of different immune genes and its

Input data are generated by the \code{scIGD} workflow is stored in a shared folder.
Expected naming scheme of the files from the data generating method:
\itemize{
\item quantification matrix: \code{cells_x_genes.mtx}
\item barcode information: \code{cells_x_genes.barcodes.txt}
\item feature information: \code{cells_x_genes.genes.txt}
\item allele lookup table: \code{lookup_table.csv}
}

File identifiers can be specifically stated if renamed.

Optional features:
\itemize{
\item Filtering: Used parameter is \code{filter_mode}. Default filtering is performed
with a threshold=0 UMIs. \code{filter_mode="yes"} performs advanced filtering based
on ranking the barcodes and infering a inflection point of a
\href{https://liorpachter.wordpress.com/tag/knee-plot/}{\strong{knee plot}}. Information
regarding the knee plot is exported in the \code{metadata(scae)[["knee_info"]]} slot
for later plotting (see vignette).
\item Computing a \code{logcount} assay by normalizing the input data based on a
sizeFactor method recommended for single-cell data. Used parameter is
\code{log=TRUE/FALSE}.
\item Computing additional gene symbols in case the input data only contains gene
identifiers represented as Ensembl ids. Used parameter is \code{gene_symbols=TRUE/FALSE}.
}
}
\examples{
example_data_5k <- scaeData::scaeDataGet(dataset="pbmc_5k")
lookup_name <- "pbmc_5k_lookup_table.csv"
lookup <- read.csv(system.file("extdata", lookup_name, package="scaeData"))


# preflight mode, default filtering with a threshold of 0 UMI counts
scae_preflight <- read_allele_counts(example_data_5k$dir,
                          sample_names="example_data",
                          filter_mode="no",
                          lookup_file=lookup,
                          barcode_file=example_data_5k$barcodes,
                          gene_file=example_data_5k$features,
                          matrix_file=example_data_5k$matrix,
                          filter_threshold=NULL)

scae_preflight

# automatic filtering mode, filtering out low-quality cells
# on the inflection point of the knee plot
#scae_filtered <- read_allele_counts(example_data_5k$dir,
#                         sample_names="example_data",
#                         filter_mode="yes",
#                         lookup_file=lookup,
#                         barcode_file=example_data_5k$barcodes,
#                         gene_file=example_data_5k$features,
#                         matrix_file=example_data_5k$matrix,
#                         filter_threshold=NULL,
#                         verbose=TRUE)

# scae_filtered

# custom filtering mode, setting up a custom filter threshold for filtering
# scae_custom_filter <- read_allele_counts(example_data_5k$dir,
#                         sample_names="example_data",
#                         filter_mode="custom",
#                         lookup_file=lookup,
#                         barcode_file=example_data_5k$barcodes,
#                         gene_file=example_data_5k$features,
#                         matrix_file=example_data_5k$matrix,
#                         filter_threshold=200)

# scae_custom_filter
}
\seealso{
\link{SingleCellAlleleExperiment}
}
