% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/SingleCellAlleleExperiment.R
\docType{class}
\name{SingleCellAlleleExperiment-class}
\alias{SingleCellAlleleExperiment-class}
\alias{.scae}
\alias{SingleCellAlleleExperiment}
\title{The SingleCellAlleleExperiment class}
\usage{
SingleCellAlleleExperiment(
  ...,
  lookup,
  metadata = NULL,
  threshold = 0,
  exp_type = "ENS",
  log = TRUE,
  gene_symbols = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{...}{Arguments passed to the \code{\link[SingleCellExperiment]{SingleCellExperiment}}
constructor to fill the slots of the SCE-class.}

\item{lookup}{A data.frame object containing the lookup table.}

\item{metadata}{A list containing a dataframe and two integer values of
information regarding plotting a knee plot for quality control. This parameter
is linked to \code{filter_mode="yes"} in the \code{read_allele_counts()} function.}

\item{threshold}{An integer value used as a threshold for filtering
low-quality barcodes/cells.}

\item{exp_type}{Internal character string parameter that determines in which
format the gene symbols in the input data are. Can be \code{c("ENS","noENS")}}

\item{log}{A logical parameter which determines if the user wants to
compute the \code{logcounts} assay.}

\item{gene_symbols}{A logical parameter to decide whether to compute additional
gene gene symbols in case the raw data only contains ENSEMBL gene identifiers.}

\item{verbose}{A logical parameter to decide if runtime-messages should be
shown during function execution. Use \code{FALSE} if no info runtime-messages
should be shown (default), and \code{TRUE} for showing runtime-messages.}
}
\value{
A SingleCellAlleleExperiment object.
}
\description{
The SingleCellAlleleExperiment class is a comprehensive multi-layer data
structure, enabling the representatino of immune genes at specific levels,
including alleles, genes and groups of functionally similar genes. This data
representation allows data handling and data analysis across these
immunological relevant, different layers of annotation.
}
\details{
The SingleCellAlleleExperiment class builds upon and extends the data
representation that can be facilitated using a \code{\link[SingleCellExperiment]{SingleCellExperiment}}
object.

The Constructor \code{SingleCellAlleleExperiment()} can be used on its own,
if raw data is processed accordingly (see examples) OR in a more
convenient way using this packages read in function \code{read_allele_counts()}

A getter function \code{scae_subset()} allows to subset the object according to
the newly implemented layers.

In this class, similar to the \code{\link[SingleCellExperiment]{SingleCellExperiment}} class,
rows should represent genomic features (including immune genes, represented
as allele information), while columns represent single cells/barcodes.

The SingleCellAlleleExperiment data structure serves as a data representation
for data generated with the \code{scIGD} workflow.
This workflow allows for the quantification of expression and interactive
exploration of donor-specific alleles of different immune genes and its
}
\examples{
##-If you want to use the Constructor on its own, some preprocessing is
##-necessary to bring the data in proper format
##-Here, we use an example dataset found in in the `scaeData` package.

##-Find an alternative and recommended read in below as a second example

example_data_5k <- scaeData::scaeDataGet(dataset="pbmc_5k")
lookup_name <- "pbmc_5k_lookup_table.csv"
lookup <- read.csv(system.file("extdata", lookup_name, package="scaeData"))

barcode_loc <- file.path(example_data_5k$dir, example_data_5k$barcodes)
feature_loc <- file.path(example_data_5k$dir, example_data_5k$features)
matrix_loc  <- file.path(example_data_5k$dir, example_data_5k$matrix)

feature_info <- utils::read.delim(feature_loc, header=FALSE)
cell_names   <- utils::read.csv(barcode_loc, sep="", header=FALSE)
mat <- t(Matrix::readMM(matrix_loc))

##-Prepare input data
colnames(feature_info) <- "Ensembl_ID"
sample_names <- "pbmc_5k"
sparse_mat <- as(mat, "CsparseMatrix")

##--colData
cell_info_list <- S4Vectors::DataFrame(Sample=rep(sample_names,
                                                 length(cell_names)),
                                      Barcode=cell_names$V1,
                                      row.names=NULL)
##--rowData and count matrix
rownames(feature_info) <- feature_info[,1]
cnames <- cell_info_list$Barcode
colnames(sparse_mat) <- cnames

scae <- SingleCellAlleleExperiment(assays=list(counts=sparse_mat),
                                   rowData=feature_info,
                                   colData=cell_info_list,
                                   lookup=lookup,
                                   verbose=TRUE)

scae

##-OR, use the read in function `read_allele_counts()` !![RECOMMENDED]!!
##-Find more examples in its documentation using `?read_allele_counts`

# scae_2 <- read_allele_counts(example_data_5k$dir,
#                              sample_names="example_data",
#                              filter_mode="no",
#                              lookup_file=lookup,
#                              barcode_file=example_data_5k$barcodes,
#                              gene_file=example_data_5k$features,
#                              matrix_file=example_data_5k$matrix,
#                              verbose=TRUE)

# scae_2

}
\seealso{
\code{\link[=read_allele_counts]{read_allele_counts()}}

\code{\link[=scae_subset]{scae_subset()}}
}
