% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problemList.R
\name{problemList}
\alias{problemList}
\title{Generate the problematic sample list.}
\usage{
problemList(seqfile)
}
\arguments{
\item{seqfile}{SeqSQC object with sample QC results.}
}
\value{
a list of 2 datasets: 1) a data frame with 2 columns:
    \code{sample} for problematic sample name, and
    \code{remove.reason} for the reason of removing the sample. 2)
    a data frame with 1 column \code{sample} for problematic
    samples to be removed.
}
\description{
generate the problematic sample list from QC steps that have been
done, and provide each problematic sample with a reason for removal
(high missing rate, gender mismatch, inbreeding outlier, cryptic
relationship or population outlier).
}
\examples{
load(system.file("extdata", "example.seqfile.Rdata", package="SeqSQC"))
problemList(seqfile)
}
\author{
Qian Liu \email{qliu7@buffalo.edu}
}
