% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SexCheck.R
\name{SexCheck}
\alias{SexCheck}
\title{Sample gender check with SeqSQC object input file.}
\usage{
SexCheck(
  seqfile,
  remove.samples = NULL,
  missing.rate = 0.1,
  ss.cutoff = 300,
  maf = 0.01,
  ...
)
}
\arguments{
\item{seqfile}{SeqSQC object, which includes the merged gds file
for study cohort and benchmark.}

\item{remove.samples}{a vector of sample names for removal from sex
check. Could be problematic samples identified from previous QC
steps, or user-defined samples.}

\item{missing.rate}{to use the SNPs with "<= \code{missing.rate}"
only; if NaN, no threshold. By default, we use
\code{missing.rate = 0.1} to filter out variants with missing
rate greater than 10\%.}

\item{ss.cutoff}{the minimum sample size (300 by default) to apply
the MAF filter. This sample size is the sum of study samples
and the benchmark samples of the same population as the study
cohort.}

\item{maf}{to use the SNPs with ">= \code{maf}" if sample size
defined in above argument is greater than \code{ss.cutoff};
otherwise NaN is used by default for no MAF threshold.}

\item{...}{Arguments to be passed to other methods.}
}
\value{
a data frame with sample name, reported gender, x
    chromosome inbreeding coefficient, and predicted gender.
}
\description{
Function to calculate the X chromosome inbreeding coefficient and
to predict sample gender.
}
\details{
Samples are predicted to be female or male if the
    inbreeding coefficient is below 0.2, or greater than 0.8,
    respectively. The samples with discordant reported gender and
    predicted gender are considered as problematic. When the
    inbreeding coefficient is within the range of [0.2, 0.8], “0”
    is shown in the column of \code{pred.sex} to indicate ambiguous
    gender, which is not considered as problematic.
}
\examples{
load(system.file("extdata", "example.seqfile.Rdata", package="SeqSQC"))
gfile <- system.file("extdata", "example.gds", package="SeqSQC")
seqfile <- SeqSQC(gdsfile = gfile, QCresult = QCresult(seqfile))
seqfile <- SexCheck(seqfile, remove.samples=NULL, missing.rate=0.1)
res.sexc <- QCresult(seqfile)$SexCheck
tail(res.sexc)
}
\author{
Qian Liu \email{qliu7@buffalo.edu}
}
\keyword{SexCheck}
