\name{DSpermutePval}
\alias{DSpermutePval}
\title{
Permutation for p-values in differential splicing analysis 
}
\description{
Calculate permutation p-values in differential splicing analysis. 
}
\usage{
DSpermutePval(RCS, permuteMat)
}
\arguments{
  \item{RCS}{a ReadCountSet object after running \code{\link{estiExonNBstat}} and \code{\link{estiGeneNBstat}}. }
  \item{permuteMat}{a permutation matrix generated by \code{\link{genpermuteMat}}. }
}
\details{
Permutation p-values are computed based on NB-statistics for comparison of the studied groups and NB-statistics from the permutation data sets. 
}
\value{
A ReadCountSet object with slots \code{permute_NBstat_exon}, \code{permute_NBstat_gene}, \code{featureData}, and \code{featureData_gene} updated. 
}
\references{
Xi Wang and Murray J. Cairns (2013). Gene Set Enrichment Analysis of RNA-Seq Data: Integrating Differential Expression and Splicing. BMC Bioinformatics, 14(Suppl 5):S16.
}
\author{
Xi Wang, xi.wang@newcastle.edu.au
}
\seealso{
\code{\link{estiExonNBstat}},
\code{\link{estiGeneNBstat}},
\code{\link{genpermuteMat}},
\code{\link{DSpermute4GSEA}}
}
\examples{
data(RCS_example, package="SeqGSEA")
permuteMat <- genpermuteMat(RCS_example, times=10)
RCS_example <- exonTestability(RCS_example)
RCS_example <- estiExonNBstat(RCS_example)
RCS_example <- estiGeneNBstat(RCS_example)
RCS_example <- DSpermutePval(RCS_example, permuteMat)
head(DSresultExonTable(RCS_example))
head(DSresultGeneTable(RCS_example))
}
