% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/camera_method.R
\name{find_camera_hit}
\alias{find_camera_hit}
\title{Find Camera Hit}
\usage{
find_camera_hit(
  screenR_Object,
  matrix_model,
  contrast,
  number_barcode = 3,
  thresh = 1e-04,
  lfc = 1,
  direction = "Down"
)
}
\arguments{
\item{screenR_Object}{The ScreenR object obtained using the
\code{\link{create_screenr_object}}}

\item{matrix_model}{The matrix that will be used to perform the
linear model analysis created using
\code{\link[stats]{model.matrix}}}

\item{contrast}{A vector or a single value indicating the index or the name
of the column the model_matrix with which perform the
analysis}

\item{number_barcode}{Number of barcode that as to be differentially
expressed (DE)in order to consider the gene associated
DE. Example a gene is associated
with 10 shRNA we consider a gene DE if it has at least
number_barcode = 5 shRNA DE.}

\item{thresh}{The threshold for the False Discovery Rate (FDR) that has to be
used to select the statistically significant hits.}

\item{lfc}{The Log2FC threshold.}

\item{direction}{String containing the direction of the variation,
"Down" for the down regulation "Up" for the up regulation.}
}
\value{
The data frame containing the hit found using the camera method
}
\description{
This function implements the method by proposed by Wu and
             Smyth (2012).
             The original \code{\link[limma]{camera}} method is a gene set
             test, here is applied in the contest of a genetic screening
             and so it erforms a competitive barcode set test.
             The paper can be found here
     \href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC3458527/}{CAMERA}
}
\examples{
object <- get0("object", envir = asNamespace("ScreenR"))

matrix <- model.matrix(~ slot(object, "groups"))
colnames(matrix) <- c("Control", "T1/T2", "Treated")

result <- find_camera_hit(
    screenR_Object = object,
    matrix_model = matrix, contrast = "Treated"
)
head(result)
}
\concept{find}
