% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by.R
\name{filter_by_variance}
\alias{filter_by_variance}
\title{Filter using the variance filter}
\usage{
filter_by_variance(
  screenR_Object,
  genes,
  matrix_model,
  variance = 0.5,
  contrast
)
}
\arguments{
\item{screenR_Object}{The ScreenR object obtained using the
\code{\link{create_screenr_object}}}

\item{genes}{The genes for which the variance as to be computed.
Those genes are the result of the three statistical
methods selection}

\item{matrix_model}{a matrix created using \code{\link[stats]{model.matrix}}}

\item{variance}{The maximum value of variance accepted}

\item{contrast}{The variable to use as X for the linear model
for the Treatment}
}
\value{
A data frame with the variance for the treatment and the control
        for each gene
}
\description{
This function is used to improve the quality of the hits.
             It compute the variance among the hits and filter the one with
             a value greater than the threshold set
}
\examples{
object <- get0("object", envir = asNamespace("ScreenR"))
matrix_model <- model.matrix(~ slot(object, "groups"))
colnames(matrix_model) <- c("Control", "T1_T2", "Treated")
contrast <- limma::makeContrasts(Treated - Control, levels = matrix_model)

data <- filter_by_variance(
    screenR_Object = object, genes = c("Gene_42"),
    matrix_model = matrix_model, contrast = contrast
)
head(data)

}
\concept{filter}
