% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by.R
\name{compute_slope}
\alias{compute_slope}
\title{Compute Slope of a Gene}
\usage{
compute_slope(screenR_Object, genes, group_var)
}
\arguments{
\item{screenR_Object}{The ScreenR object obtained using the
\code{\link{create_screenr_object}}}

\item{genes}{The genes for which the slope as to be computed. Those genes
are the result of the three statistical methods selection}

\item{group_var}{The variable to use  as independent variable (x)
for the linear model}
}
\value{
A tibble containing in each row the gene and the corresponding Slope
}
\description{
This function is used to compute the slope of the gene passed
             as input
}
\examples{
object <- get0("object", envir = asNamespace("ScreenR"))

compute_slope(object,
    genes = c("Gene_42", "Gene_24"),
    group_var = c("T1", "T2", "TRT")
)
}
\concept{compute}
