% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post.processing.R
\name{PostProcessing}
\alias{PostProcessing}
\title{Post-processing for scone analysks.}
\usage{
PostProcessing(
  scone.output,
  cell.data,
  input,
  tsne = TRUE,
  log.transform.qvalue = TRUE
)
}
\arguments{
\item{scone.output}{tibble of the output of the given scone analysis}

\item{cell.data}{the tibble used as input for the scone.values function}

\item{input}{the input markers used for the knn calculation (to be used
for tsne here)}

\item{tsne}{boolean value to indicate whether tSNE is to be done}

\item{log.transform.qvalue}{boolean to indicate whether log transformation
of all q values is to be done}
}
\value{
result: the concatenated original input data with the scone derived
data, with the option of the q values being inverse log10 transformed, and
two additional tSNE columns being added to the data (from the Rtsne package)
}
\description{
Performs final processing and transformations on the scone data
}
\examples{
PostProcessing(wand.scone, wand.combined, input.markers, tsne = FALSE)
}
