% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unifyProteinGroupLabels.R
\name{unifyProteinGroupLabels}
\alias{unifyProteinGroupLabels}
\title{Unify the protein group labels.}
\usage{
unifyProteinGroupLabels(data, column = "ProteinName")
}
\arguments{
\item{data}{A data frame containing SWATH data.}

\item{column}{Which column to use for unifying the protein group identifiers.}
}
\value{
Returns a data frame with the unififed protein labels.
}
\description{
Unify the protein group labels (2/ProteinA/ProteinB and 2/ProteinB/ProteinA)
to one common label (e.g. 2/ProteinA/ProteinB)
}
\examples{
 data("OpenSWATH_data", package="SWATH2stats")
 data("Study_design", package="SWATH2stats")
 data <- sample_annotation(OpenSWATH_data, Study_design)
 data.filtered.decoy <- filter_mscore(data, 0.01)
 data.unified <- unifyProteinGroupLabels(data.filtered.decoy)
}
\author{
Moritz Heusel
}
