% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeDecoyProteins.R
\name{removeDecoyProteins}
\alias{removeDecoyProteins}
\title{Removes decoy proteins from the protein group label}
\usage{
removeDecoyProteins(data, column = "ProteinName", decoy_string = "DECOY")
}
\arguments{
\item{data}{A data frame containing SWATH data.}

\item{column}{Column to query for decoy string}

\item{decoy_string}{String defining a decoy. Default: DECOY}
}
\value{
Returns a data frame with changed protein labels
}
\description{
There exist peptides annotated as protein groups with
2/ProteinA/DECOY_ProteinB. However these are in principal proteotypic
peptides and should be annoated 1/ProteinA. This function changes these
labels accordingly. The subfunction rmDecoyProt removes the Decoy protein,
calling removeDecoyProteins also changes the nubmer before the protein group
accordingly.
}
\examples{
 data("OpenSWATH_data", package="SWATH2stats")
 data("Study_design", package="SWATH2stats")
 data <- sample_annotation(OpenSWATH_data, Study_design)
 data.filtered.decoy <- filter_mscore(data, 0.01)
 data.2 <- removeDecoyProteins(data.filtered.decoy)
}
\author{
Moritz Heusel
}
