% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fdr_table.R
\name{plot.fdr_table}
\alias{plot.fdr_table}
\title{S3 plot function for results of class "fdr_table" as produced by e.g. the
function assess_fdr_overall()}
\usage{
\method{plot}{fdr_table}(x, output = "Rconsole", filename = "FDR_report_overall", ...)
}
\arguments{
\item{x}{List of class "fdr_table" as produced e.g. by the function
assess_fdr_overall() from this package.}

\item{output}{Choose output type. "pdf_csv" creates the output as files in
the working directory, "Rconsole" triggers delivery of the output to the
console enabling further computation or custom plotting / output.}

\item{filename}{Basename for output files to be created (if output =
"pdf_csv" has been selected).}

\item{...}{Extra arguments passed on to functions inside this.}
}
\value{
Plots in Rconsole or report files.
}
\description{
This function created standard plots from results of class "fdr_table" as
produced by e.g. the function assess_fdr_overall() visualizig ID numbers in
dependence of estimated FDR and also estimated FDR in dependence of m_score
cutoff.
}
\examples{
{
 data("OpenSWATH_data", package="SWATH2stats")
 data("Study_design", package="SWATH2stats")
 data <- sample_annotation(OpenSWATH_data, Study_design)
 x <- assess_fdr_overall(data, FFT=0.7, output="Rconsole", plot=FALSE)
 plot(x, output="Rconsole", filename="Assess_fdr_overall_testplot")
 }
}
\author{
Moritz Heusel
}
