% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-localbv.R
\name{runLOCALBV}
\alias{runLOCALBV}
\alias{runLOCALBV,SingleCellExperiment-method}
\alias{runLOCALBV,SingleCellExperiment}
\alias{runLOCALBV,SVPExperiment-method}
\alias{runLOCALBV,SVPExperiment}
\title{Local Bivariate analysis with spatial autocorrelation}
\usage{
runLOCALBV(
  data,
  features1 = NULL,
  features2 = NULL,
  assay.type = "logcounts",
  sample_id = "all",
  bv.method = c("locallee", "localmoran_bv"),
  bv.alternative = "two.sided",
  weight = NULL,
  weight.method = c("voronoi", "knn", "none"),
  lisa.method = c("localG", "localmoran"),
  lisa.alternative = "greater",
  lisa.flag.method = c("mean", "median"),
  reduction.used = NULL,
  group.by = NULL,
  permutation = 100,
  random.seed = 1024,
  BPPARAM = SerialParam(),
  action = c("get", "only", "add"),
  verbose = TRUE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  gsvaexp.features = NULL,
  across.gsvaexp = TRUE,
  ...
)

\S4method{runLOCALBV}{SingleCellExperiment}(
  data,
  features1 = NULL,
  features2 = NULL,
  assay.type = "logcounts",
  sample_id = "all",
  bv.method = c("locallee", "localmoran"),
  bv.alternative = "two.sided",
  weight = NULL,
  weight.method = c("voronoi", "knn", "none"),
  lisa.method = c("localG", "localmoran"),
  lisa.alternative = "greater",
  lisa.flag.method = c("mean", "median"),
  reduction.used = NULL,
  group.by = NULL,
  permutation = 100,
  random.seed = 1024,
  BPPARAM = SerialParam(),
  action = c("get", "only", "add"),
  verbose = TRUE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  gsvaexp.features = NULL,
  across.gsvaexp = TRUE,
  ...
)

\S4method{runLOCALBV}{SVPExperiment}(
  data,
  features1 = NULL,
  features2 = NULL,
  assay.type = "logcounts",
  sample_id = "all",
  bv.method = c("locallee", "localmoran_bv"),
  bv.alternative = "two.sided",
  weight = NULL,
  weight.method = c("voronoi", "knn", "none"),
  lisa.method = c("localG", "localmoran"),
  lisa.alternative = "greater",
  lisa.flag.method = c("mean", "median"),
  reduction.used = NULL,
  group.by = NULL,
  permutation = 100,
  random.seed = 1024,
  BPPARAM = SerialParam(),
  action = c("get", "only", "add"),
  verbose = TRUE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  gsvaexp.features = NULL,
  across.gsvaexp = TRUE,
  ...
)
}
\arguments{
\item{data}{a \linkS4class{SingleCellExperiment} object with contains \code{UMAP} or \code{TSNE},
or a \linkS4class{SpatialExperiment} object, or a \linkS4class{SVPExperiment} object with specified
\code{gsvaexp} argument.}

\item{features1}{the features name data object (only supporting character), see also \code{features2} parameter.}

\item{features2}{character, if \code{features1} is not NULL, and \code{features2} is NULL,
only the \code{features1} are analyzed, if \code{features1} is NULL, and \code{features2} is
is not NULL, the \code{features2} are analyzed, if \code{features2} is also NULL, all of features in the
\code{data} object will be analyzed. If \code{features2} and \code{features1} are not NULL, the bivariate
spatial autocorrelation analysis will be performed between the \code{features1} and \code{features2}.
default is \code{NULL}.}

\item{assay.type}{which expressed data to be pulled to run, default is \code{logcounts}.}

\item{sample_id}{character the sample(s) in the \linkS4class{SpatialExperiment} object whose cells/spots to use.
Can be \code{all} to compute metric for all samples; the metric is computed separately for each sample.
default is \code{"all"}.}

\item{bv.method}{character one of the \code{'locallee'} and \code{'localmoran_bv'}, default is \code{'locallee'}.}

\item{bv.alternative}{a character string specifying the alternative hypothesis, default is \code{tow.sided}.
This only work when \code{bv.method = 'localmoran_bv'}.}

\item{weight}{object, which can be \code{nb}, \code{listw} or \code{Graph} object, default is NULL,
meaning the spatial neighbours weights will be calculated using the \code{weight.method}.
if the \code{data} contains multiple samples, and the \code{sample_id} is specified, it should be
provided as a list object with names (using \code{sample_id}).}

\item{weight.method}{character the method to build the spatial neighbours weights, default
is \code{voronoi} (Voronoi tessellation). Other method, which requires coord matrix as input and returns
\code{nb}, \code{listw} or \code{Graph} object, also is available, such as \code{"knearneigh"},
\code{'dnearneigh'}, \code{"gabrielneigh"}, \code{"relativeneigh"}, which are from \code{spdep} package.
default is \code{knn}, if it is \code{"none"}, meaning the distance weight of each spot is used to
the weight.}

\item{lisa.method}{character one of the \code{'localG'} and \code{'localmoran'}, this is to perform the \code{LISA}
analysis using the result of bv.method, which can identify the spatial domain of the bivariate spatial
analysis result, default is \code{'localG'}.}

\item{lisa.alternative}{a character string specifying the alternative hypothesis, which works with
\code{lisa.method}, default is \code{greater}.}

\item{lisa.flag.method}{a character string specifying the method to calculate the threshold for the cluster
type, default is \code{"mean"}. Other option is \code{"median"}.}

\item{reduction.used}{character used as spatial coordinates to calculate the neighbours weights,
default is \code{NULL}, the result of reduction can be specified, such as \code{UMAP}, \code{TSNE}, \code{PCA}.
If it is specified, the weight neighbours matrix will be calculated using the result of specified reduction.}

\item{group.by}{character a specified category column names (for example the cluster column name) of
\code{colData(data)}. Or a vector of length equal to ‘ncol(x)’, specifying the group to which each cell
is assigned. If it was specified, the adjacency weighted matrix will be built based on the principle that
spots or cells in the same category are adjacent, default is NULL.}

\item{permutation}{integer the permutation number to test, which only work with \code{bv.method='localmoran_bv'},
default is 100L.}

\item{random.seed}{numeric random seed number to repeatability, default is 1024.}

\item{BPPARAM}{A BiocParallelParam object specifying whether perform the analysis in parallel using
\code{BiocParallel} default is \code{SerialParam()}, meaning no parallel.
You can use \code{BiocParallel::MulticoreParam(workers=4, progressbar=TRUE)} to parallel it,
the \code{workers} of \code{MulticoreParam} is the number of cores used, see also
\code{\link[BiocParallel]{MulticoreParam}}. default is \code{SerialParam()}.}

\item{action}{character, which control the type of return result, default is \code{get}, which will return
a \linkS4class{SimpleList}.}

\item{verbose}{logical whether print the help information, default is TRUE.}

\item{gsvaexp}{character the one character from the name of \code{gsvaExpNames(data)}, default is NULL. If \code{data}
is \linkS4class{SVPExperiment}, and the parameter is specified simultaneously. the \code{features} (Usually genes)
from the displayed class, and \code{gsvaexp.features} from name in \code{rownames(gsvaExp(data, gsvaexp))} will be
performed the analysis.}

\item{gsvaexp.assay.type}{character the assay name in the \code{assays(gsvaExp(data, gsvaexp))}, default is NULL,
which works with \code{gsvaexp} parameter.}

\item{gsvaexp.features}{character the name from the \code{rownames(gsvaExp(data, gsvaexp))}. If \code{gsvaexp} is
specified and \code{data} is \linkS4class{SVPExperiment}, it should be provided. Default is NULL.}

\item{across.gsvaexp}{logical whether only calculate the relationship of features between the multiple \code{gsvaExps}
not the internal features of gsvaExp. For example, \code{'a'} and \code{'b'} features are from the \code{'AB'} \code{gsvaExp},
\code{'c'} and \code{'d'} features are from the \code{'CD'} \code{gsvaExp}. When \code{across.gsvaexp=TRUE} and
\code{gsvaexp.features = c('a', 'b', 'c', 'd')} and \code{gsvaexp = c('AB', 'CD')}, Only the relationship of
\code{a} and \code{c}, \code{a} and \code{d}, \code{b} and \code{c}, and \code{b} and \code{d} will be calculated.
default is TRUE.}

\item{...}{additional parameters the parameters which are from the weight.method function.}
}
\value{
if \code{action = 'get'} (in default), the SimpleList object (like list object) will be return,
if \code{action = 'only'}, the data.frame will be return. if \code{action = 'add'}, the result of LISA is
stored in the \code{localResults} column of \code{int_colData} (internal column metadata). You can use
\code{localResults()} function of \code{SpatialFeatureExperiment} package to extract it.
}
\description{
This function is to explore the local bivariate relationship in the spatial space. Like
\code{runGLOBALBV}, It efficiently reflects the extent to which bivariate associations
are spatially grouped in local. Put differently, it can be utilized to quantify the
bivariate spatial dependency in local. See also the references.
}
\examples{
data(hpda_spe_cell_dec)
res1 <- hpda_spe_cell_dec |> runLOCALBV(
          features1 = 'Cancer clone A', 
          features2 = 'Cancer clone B', 
          assay.type='affi.score'
        )
res1
res1[['Cancer clone A_VS_Cancer clone B']] |> head()
# add the LocalLee and Gi of LOCALBV result to input object.
hpda_spe_cell_dec <- LISAsce(hpda_spe_cell_dec, res1, 'LOCALBV')
hpda_spe_cell_dec
gsvaExp(hpda_spe_cell_dec, 'LOCALBV')
# Then using ggsc to visualize the result
#\donttest{
  library(ggplot2)
  library(ggsc)
  gsvaExp(hpda_spe_cell_dec, 'LOCALBV') |>
  plot_lisa_feature(res1, assay.type='LocalLee') + ggtitle(NULL)
#}
}
\references{
Lee, SI. Developing a bivariate spatial association measure: An integration of Pearson's r and Moran's I .
J Geograph Syst 3, 369–385 (2001). https://doi.org/10.1007/s101090100064
}
\seealso{
\code{\link{runDetectSVG}} and \code{\link{runKldSVG}} to identify the spatial variable features, \code{\link{runGLOBALBV}} to
analysis the global bivariate spatial analysis, \code{\link{runLISA}} to identify the spatial domain of specified features.
}
\author{
Shuangbin Xu
}
