% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-lisaRes.R
\name{LISAsce}
\alias{LISAsce}
\alias{LISAsce,SingleCellExperiment-method}
\alias{LISAsce,SingleCellExperiment}
\title{convert LISA result to SVPExperiment.}
\usage{
LISAsce(data, lisa.res, gsvaexp.name = "LISA", ...)

\S4method{LISAsce}{SingleCellExperiment}(data, lisa.res, gsvaexp.name = "LISA", ...)
}
\arguments{
\item{data}{a \linkS4class{SingleCellExperiment} object with contains \code{UMAP} or \code{TSNE},
or a \linkS4class{SpatialExperiment} object, or a \linkS4class{SVPExperiment} object.}

\item{lisa.res}{list the result of \code{runLISA} or \code{runLOCALBV}.}

\item{gsvaexp.name}{character the name of gsveExp for the LISA result, default is "LISA".}

\item{...}{currently meaningless.}
}
\value{
a SVPExperiment object
}
\description{
convert the Gi for \code{runLISA} result or LocalLee for \code{runLOCALBV} result
to a \linkS4class{SVPExperiment}.
}
\examples{
data(hpda_spe_cell_dec)
lisa.res12 <- hpda_spe_cell_dec |>
   runLISA(
     features = c(1, 2, 3),
     assay.type = 'affi.score',
     weight.method = "knn",
     k = 10,
     action = 'get',
   )
hpda_spe_cell_dec <- LISAsce(hpda_spe_cell_dec, lisa.res12)
hpda_spe_cell_dec
gsvaExp(hpda_spe_cell_dec, 'LISA')
localbv.res1 <- hpda_spe_cell_dec |> runLOCALBV(
          features1 = 'Cancer clone A',
          features2 = 'Cancer clone B',
          assay.type='affi.score'
        )
hpda_spe_cell_dec <- LISAsce(hpda_spe_cell_dec, localbv.res1, 'LOCALBV')
gsvaExp(hpda_spe_cell_dec, 'LOCALBV')
}
\seealso{
\code{\link{runLISA}} and \code{\link{runLOCALBV}}
}
