% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_transcription_rates-class.R
\docType{class}
\name{ExperimentTranscriptionRates-class}
\alias{ExperimentTranscriptionRates-class}
\alias{estimateTranscriptionRates,character-method}
\alias{rates,ExperimentTranscriptionRates-method}
\alias{counts}
\alias{counts,ExperimentTranscriptionRates-method}
\alias{pauseRegions}
\alias{pauseRegions,ExperimentTranscriptionRates-method}
\alias{geneBodyRegions}
\alias{geneBodyRegions,ExperimentTranscriptionRates-method}
\alias{omegaScale}
\alias{omegaScale,ExperimentTranscriptionRates-method}
\alias{stericHindrance,ExperimentTranscriptionRates-method}
\title{Constructor for ExperimentTranscriptionRates object}
\usage{
\S4method{estimateTranscriptionRates}{character}(
  x,
  bigwigMinus,
  pauseRegions,
  geneBodyRegions,
  name,
  stericHindrance = FALSE,
  omegaScale = NULL
)

\S4method{rates}{ExperimentTranscriptionRates}(object)

counts(object)

\S4method{counts}{ExperimentTranscriptionRates}(object)

pauseRegions(object)

\S4method{pauseRegions}{ExperimentTranscriptionRates}(object)

geneBodyRegions(object)

\S4method{geneBodyRegions}{ExperimentTranscriptionRates}(object)

omegaScale(object)

\S4method{omegaScale}{ExperimentTranscriptionRates}(object)

\S4method{stericHindrance}{ExperimentTranscriptionRates}(object)
}
\arguments{
\item{x}{The path to a bigwig file from the plus strand recording PRO-seq
read counts}

\item{bigwigMinus}{the path to a bigwig file from the minus strand recording
PRO-seq read counts}

\item{pauseRegions}{a \link[GenomicRanges]{GRanges-class} object that must
contain a gene_id}

\item{geneBodyRegions}{a \link[GenomicRanges]{GRanges-class} object that
must contain a gene_id}

\item{name}{a character value for the name of the experiment}

\item{stericHindrance}{a logical value to determine whether to infer
landing-pad occupancy or not. Defaults to FALSE.}

\item{omegaScale}{a numeric value for scaling omega. Defaults to NULL.}

\item{object}{an \code{ExperimentTranscriptionRates} object}
}
\value{
an \code{\link{ExperimentTranscriptionRates-class}} object

a \code{DataFrame} with the following columns:
\item{geneId}{a character vector of gene IDs}
\item{chi}{a numeric vector of RNAP density along gene body}
\item{betaOrg}{a numeric vector }
\item{betaAdp}{a numeric vector }
\item{fkMean}{a numeric vector of the mean position of pause sites}
\item{fkVar}{a numeric vector of the variance of pause site positions}
\item{phi}{a numeric vector of the landing-pad occupancy}
\item{betaZeta}{a numeric vector of the pause-escape rate}
\item{alphaZeta}{a numeric vector of the potential initiation rate}
\item{omega}{a numeric vector of the effective initiation rate}
\item{omegaZeta}{a numeric vector of the effective initiation rate}
\item{expectedPauseSiteCounts}{a numeric vector of the expected pause site
counts}
\item{actualPauseSiteCounts}{a numeric vector of the actual pause site
counts that are observed}
\item{likelihood}{a numeric vector of the likelihood of the model}

a \code{DataFrame} with the following columns:
\item{geneId}{a character vector of gene IDs}
\item{summarizedGbCounts}{a numeric vector of the sum of gene body read
counts}
\item{gbLength}{a numeric vector of the gene body length}
\item{summarizedPauseCounts}{a numeric vector of the sum of pause region
read counts}

a \link[GenomicRanges]{GRanges-class} object with the pause regions

a \link[GenomicRanges]{GRanges-class} object with the gene body
regions

a numeric value for the scaling factor for omega

a logical value to determine whether to infer landing-pad occupancy
or not
}
\description{
Class \code{ExperimentTranscriptionRates} has read counts, pause and gene
body genomic region coordinates, steric hindrance and omega scale factor
parameters used to estimate the transcription rates as well as the estimated
rates

Estimates the transcription rates using Expectation Maximization likelihood
formula. Estimates initiation, pause-release rates, average read depth along
gene body and pause regions. If steric hindrance is enabled, also estimates
the landing pad occupancy. Estimated from experimental data, such as nascent
RNA sequencing read counts and genomic coordinates, and contructs an object
that holds these rates. Considers models where pause sites are fixed or
varied. Considers models where steric hindrance is enabled or disabled.

Accessor for the estimated rates

Accessor for the read counts

Accessor for the pause region coords \link[GenomicRanges]{GRanges-class}

Accessor for the gene body regions coords \link[GenomicRanges]{GRanges-class}

Accessor for the omega scale used to scale the omega value based on prior
studies.

Accessor for the steric hindrance flag. If TRUE, the landing-pad
occupancy is inferred in the rates held in this object.
}
\section{Slots}{

\describe{
\item{\code{counts}}{a \code{data.frame} with five columns gene_id,
summarizedPauseCounts, pauseLength, summarizedGbCounts, gbLength}

\item{\code{bigwigPlus}}{a path to bigwig for plus strand recording PRO-seq read
counts. This can be generated with the proseq2.0 pipeline.}

\item{\code{bigwigMinus}}{a path to bigwig for minus strand recording PRO-seq read
counts. This can be generated with the proseq2.0 pipeline.}

\item{\code{pauseRegions}}{a \code{\link[GenomicRanges]{GRanges-class}} object that
holds the pause regions coordinates}

\item{\code{geneBodyRegions}}{a \code{\link[GenomicRanges]{GRanges-class}} object
that holds the gene body regions coordinates}

\item{\code{name}}{a character value for the name of the experiment}

\item{\code{stericHindrance}}{a logical value indicating whether to infer
landing-pad occupancy}

\item{\code{omegaScale}}{a numeric value for scaling omega, or NULL if steric
hindrance is disabled}

\item{\code{rates}}{a \code{\link[tibble]{tbl_df}} containing the estimated rates
with columns:
\describe{
\item{geneId}{Character. Gene identifier}
\item{chi}{Numeric. RNAP density along gene body given as estimate for the
gene body elongation rate \verb{[RNAPs/bp]}}
\item{betaOrg}{Numeric. Ratio of gene body RNAP density to pause region
RNAP density with fixed pause sites given as an estimate for the
pause-escape rate}
\item{betaAdp}{Numeric. Ratio of gene body RNAP density to pause region
RNAP density from adapted model which allows pause sites to vary across
cells given as an estimate for the pause-escape rate}
\item{fkMean}{Numeric. Mean position of pause sites}
\item{fkVar}{Numeric. Variance of pause site positions}
\item{phi}{Numeric. Landing-pad occupancy (only if steric hindrance is
enabled)}
\item{betaZeta}{Numeric. Pause-escape rate (only if steric hindrance is
enabled)}
\item{alphaZeta}{Numeric. Potential initiation rate (only if steric
hindrance is enabled)}
\item{omegaZeta}{Numeric. Effective initiation rate (only if steric
hindrance is enabled)}
\item{totalGbRc}{Numeric. Total gene body read counts}
\item{gbLength}{Numeric. Gene body length}
\item{expectedPauseSiteCounts}{Numeric. Expected pause site counts}
\item{actualPauseSiteCounts}{Numeric. Observed pause site counts}
}}
}}

\examples{
# Create an ExperimentTranscriptionRates object
load(system.file("extdata", "granges_for_read_counting_DLD1_chr21.RData",
package = "STADyUM"))
expRates <- estimateTranscriptionRates(system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_plus_chr21.bw", package = "STADyUM"),
bigwigMinus = system.file("extdata",
"PROseq-DLD1-aoi-NELFC_Auxin_Ctrl-SE_minus_chr21.bw", package = "STADyUM"),
    pauseRegions = bw_pause_filtered,
    geneBodyRegions = bw_gb_filtered,
    name = "Control",
    stericHindrance = TRUE,
    omegaScale = 1000
)

}
