% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQL_extensions.R
\docType{class}
\name{SQLiteColumnSeed-class}
\alias{SQLiteColumnSeed-class}
\alias{SQLiteDataFrame-class}
\alias{DuckDBDataFrame-class}
\alias{SQLiteColumnVector-class}
\alias{DuckDBColumnSeed-class}
\alias{DuckDBColumnVector-class}
\alias{DelayedArray,SQLiteColumnSeed-method}
\alias{DelayedArray,DuckDBColumnSeed-method}
\title{SQL extensions}
\arguments{
\item{path}{String containing a path to a SQL file.}

\item{table}{String containing the name of the table in SQL file.}

\item{column}{String containing the name of the column inside the
table.}

\item{length}{Integer containing the number of rows. If
\code{NULL}, this is determined by inspecting the SQL
table. This should only be supplied for efficiency purposes, to
avoid a file look-up on construction.}

\item{type}{String specifying the type of the data. If \code{NULL},
this is determined by inspecting the file. Users may specify
this to avoid a look-up, or to coerce the output into a
different type.}
}
\description{
Extensions of SQLDataFrame, SQLColumnVector, SQLColumnSeed with
different SQL backends. Currently supporting SQLite and DuckDB,
with which the definition coding can be followed for added
extension of other SQL backends.
}
\examples{
## Mocking up a file:

### SQLite
tf <- tempfile()
on.exit(unlink(tf))
con <- DBI::dbConnect(RSQLite::SQLite(), tf)
DBI::dbWriteTable(con, "mtcars", mtcars)
DBI::dbDisconnect(con)

### DuckDB
tf1 <- tempfile()
on.exit(unlist(tf1))
con <- DBI::dbConnect(duckdb::duckdb(), tf1)
DBI::dbWriteTable(con, "mtcars", mtcars)
DBI::dbDisconnect(con)

## Constructor of xxColumnSeed and xxColumnVector

sd <- SQLiteColumnSeed(tf, "mtcars", "gear")
scv <- SQLiteColumnVector(sd)
scv1 <- SQLiteColumnVector(tf, "mtcars", "gear")
identical(scv, scv1)

DuckDBColumnSeed(tf1, "mtcars", "mpg")
DuckDBColumnVector(tf1, "mtcars", "mpg")

## Constructor of xxDataFrame

SQLiteDataFrame(tf, "mtcars")
DuckDBDataFrame(tf1, "mtcars")

}
