% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluateDensities.R
\name{evaluateDensities}
\alias{evaluateDensities}
\title{Evaluate the densities in the estimated SPsimSeq object}
\usage{
evaluateDensities(SPobj, newData = names(SPobj$detailed.results$densList))
}
\arguments{
\item{SPobj}{The SPsimSeq object, with details retained}

\item{newData}{A character vector of gene names}
}
\value{
a list of estimated densities, breaks and midpoints, one for every 
gene in newData
}
\description{
Evaluate the densities in the estimated SPsimSeq object
}
\examples{
data("zhang.data.sub")
# filter genes with sufficient expression (important step to avoid bugs)
zhang.counts <- zhang.data.sub$counts
MYCN.status  <- zhang.data.sub$MYCN.status
# simulate data
sim.data.bulk <- SPsimSeq(n.sim = 1, s.data = zhang.counts,
                          group = MYCN.status, n.genes = 2000, batch.config = 1,
                          group.config = c(0.5, 0.5), tot.samples = 20,
                          pDE = 0.1, lfc.thrld = 0.5, result.format = "list",
                          return.details = TRUE)
outDens = evaluateDensities(sim.data.bulk)
select.genes <- sample(names(outDens), 4)
select.sample = sample(
seq_along(sim.data.bulk$detailed.results$exprmt.design$sub.groups), 1)
par(mfrow=c(2, 2))
for(i in select.genes){
     plot(outDens[[i]][[select.sample]]$mids, outDens[[i]][[select.sample]]$gy, type = "l", 
     xlab = "Outcome", ylab = "Density", main = paste("Gene", i))
  }
}
