% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTopicProfiles.R
\name{plotTopicProfiles}
\alias{plotTopicProfiles}
\title{Plot NMF topic profiles}
\usage{
plotTopicProfiles(x, y, facet = FALSE, min_prop = 0.01, ncol = NULL)
}
\arguments{
\item{x}{\code{list} object obtained from \code{SPOTlight}.}

\item{y}{vector of group labels. Should be of length
\code{ncol(res_lvl1$NMF$h)}.}

\item{facet}{logical indicating whether to stratify by group.
If \code{FALSE} (default), weights will be the median across cells
for each group (point = topic weight for a given cell type).
If \code{TRUE}, cell-specific weights will be shown
(point = topic weight of a given cell).}

\item{min_prop}{scalar in [0,1]. When \code{facet = TRUE},
only cells with a weight > \code{min_prop} will be included.}

\item{ncol}{integer scalar specifying the number of facet columns.}
}
\value{
\code{ggplot} object
}
\description{
This function takes in the fitted NMF model and returns the
  topic profiles learned for each cell \code{facet = FALSE} or cell type
  \code{facet = TRUE}. Ideal training will return all the cell from the same
  cell type to share a unique topic profile.
}
\examples{
library(ggplot2)
x <- mockSC()
y <- mockSP(x)
z <- getMGS(x)

res <- SPOTlight(x, y,
    groups = x$type,
    mgs = z,
    group_id = "type",
    verbose = FALSE)

plotTopicProfiles(res[[3]], x$type, facet = TRUE)
plotTopicProfiles(res[[3]], x$type, facet = FALSE)
}
\author{
Marc Elosua Bayes & Helena L Crowell
}
