% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotImage.R
\name{plotImage}
\alias{plotImage}
\title{Plot JP(E)G/PNG/Raster/RGB images}
\arguments{
\item{x}{A variety of objects can be passed: character string corresponding
to an image file path, valid file types are JPG, JPEG and PNG. It can also
take as input objects of class raster and RGB arrays. It can also take
a SpatialExperiment from which the image will be extracted.}

\item{slice}{Character string indicating which image slice to use when
SpatialExperiment objects are passed. By default uses the first
slice available.}
}
\value{
\code{ggplot} object
}
\description{
This function takes in an image-related object - path to
  JP(E)G/PNG file, raster object, RGBarray. It returns a ggplot object with
  the selected image.
}
\examples{
# Filename
path <- file.path(
  system.file(package = "SPOTlight"), 
  "extdata/SPOTlight.png")
plotImage(x = path)
# array
png_img <- png::readPNG(path)
plotImage(png_img)
# SpatialExperiment
}
\author{
Marc Elosua Bayes & Helena L Crowell
}
